/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer;

import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.common.tools.UUIDMap;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.raphimc.noteblocklib.NoteBlockLib;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.model.Song;

public class EmoteSerializer {
    public static final String FOLDER_PATH_KEY = "folderpath";
    public static final String BUILT_IN_KEY = "isBuiltin";
    public static final String FILENAME_KEY = "fileName";

    public static void serializeEmotes(UUIDMap<Animation> emotes, Path externalEmotes) {
        if (!Files.isDirectory(externalEmotes, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(externalEmotes, FileVisitOption.FOLLOW_LINKS);){
            ((Stream)paths.filter(file -> UniversalEmoteSerializer.findReader(file.getFileName().toString()).isPresent()).parallel()).forEach(file -> {
                String folderPath = externalEmotes.relativize(file.getParent()).normalize().toString().replace(File.separator, "/");
                if (folderPath.startsWith("server") || folderPath.contains("_export")) {
                    return;
                }
                emotes.addAll(EmoteSerializer.serializeExternalEmote(file, folderPath));
            });
        }
        catch (Throwable e) {
            CommonData.LOGGER.warn("Failed to walk emotes!", e);
        }
    }

    public static List<Animation> serializeExternalEmote(Path file) {
        return EmoteSerializer.serializeExternalEmote(file, null);
    }

    public static List<Animation> serializeExternalEmote(Path file, String folderPath) {
        List<Animation> list;
        block25: {
            String fileName = file.getFileName().toString();
            String baseFileName = EmoteSerializer.getBaseName(fileName);
            InputStream reader = Files.newInputStream(file, new OpenOption[0]);
            try {
                Path song;
                List<Animation> emotes = UniversalEmoteSerializer.readData(reader, fileName);
                for (Animation emote : emotes) {
                    ExtraAnimationData data = emote.data();
                    if (folderPath != null && !folderPath.isBlank()) {
                        data.put(FOLDER_PATH_KEY, (Object)folderPath);
                    }
                    data.put(FILENAME_KEY, (Object)fileName);
                    data.data().remove(BUILT_IN_KEY);
                }
                Path icon = file.getParent().resolve(baseFileName + ".png");
                if (Files.isRegularFile(icon, new LinkOption[0])) {
                    try (InputStream iconStream = Files.newInputStream(icon, new OpenOption[0]);){
                        ByteBuffer byteBuffer = MathHelper.readFromIStream((InputStream)iconStream);
                        for (Animation emote : emotes) {
                            emote.data().put("iconData", (Object)byteBuffer);
                        }
                    }
                    catch (Throwable th) {
                        CommonData.LOGGER.warn("Error while reading icon: {}", (Object)icon.getFileName(), (Object)th);
                    }
                }
                if (Files.isRegularFile(song = file.getParent().resolve(baseFileName + ".nbs"), new LinkOption[0])) {
                    try {
                        Song nbs = NoteBlockLib.readSong((Path)song, (SongFormat)SongFormat.NBS);
                        for (Animation emote : emotes) {
                            emote.data().put("song", (Object)nbs);
                        }
                    }
                    catch (Throwable th) {
                        CommonData.LOGGER.warn("Error while reading song: {}", (Object)song.getFileName(), (Object)th);
                    }
                }
                list = emotes;
                if (reader == null) break block25;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable th) {
                    CommonData.LOGGER.warn("Error while importing external emote: {}", (Object)file.getFileName(), (Object)th);
                    return Collections.emptyList();
                }
            }
            reader.close();
        }
        return list;
    }

    protected static String getBaseName(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            fileName = fileName.substring(0, i);
        }
        return fileName;
    }
}

