/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.screen;

import com.mojang.serialization.Codec;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.EmoteMenu;
import io.github.kosmx.emotes.arch.screen.ExportMenu;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.server.config.Serializer;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends OptionsSubScreen {
    private static final Component TITLE = Component.translatable((String)"emotecraft.otherconfig");
    private static final Component CATEGORY_GENERAL = Component.translatable((String)"emotecraft.otherconfig.category.general");
    private static final Component CATEGORY_EXPERT = Component.translatable((String)"emotecraft.otherconfig.category.expert");
    private static final Component CATEGORY_LEGACY = Component.translatable((String)"emotecraft.otherconfig.category.legacy");
    private static final Component RESET_CONFIG_TITLE = Component.translatable((String)"emotecraft.resetConfig.title");
    private static final Component RESET_CONFIG_MSG = Component.translatable((String)"emotecraft.resetConfig.message");
    private static final Component EXPORT = Component.translatable((String)"emotecraft.options.export");

    public ConfigScreen(Screen parent) {
        super(parent, Minecraft.getInstance().options, TITLE);
    }

    protected void addOptions() {
        assert (this.list != null);
        this.list.addSmall(Collections.singletonList(new StringWidget(CATEGORY_GENERAL, this.font)));
        PlatformTools.getConfig().basics.forEach(entry -> this.addConfigEntry((SerializableConfig.ConfigEntry)entry, this.list));
        this.list.addSmall(Collections.singletonList(new StringWidget(CATEGORY_EXPERT, this.font)));
        PlatformTools.getConfig().expert.forEach(entry -> this.addConfigEntry((SerializableConfig.ConfigEntry)entry, this.list));
        this.list.addSmall(Collections.singletonList(new StringWidget(CATEGORY_LEGACY, this.font)));
        PlatformTools.getConfig().legacy.forEach(entry -> this.addConfigEntry((SerializableConfig.ConfigEntry)entry, this.list));
    }

    protected void addFooter() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearLayout.addChild((LayoutElement)Button.builder((Component)EmoteMenu.RESET, button -> this.minecraft.setScreen((Screen)new ConfirmScreen(this::resetAll, RESET_CONFIG_TITLE, RESET_CONFIG_MSG))).width(120).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)EXPORT, button -> this.minecraft.setScreen((Screen)new ExportMenu((Screen)this))).width(120).build());
    }

    private <T> void addConfigEntry(SerializableConfig.ConfigEntry<T> entry, OptionsList options) {
        if (entry.showEntry() || PlatformTools.getConfig().showHiddenConfig.get().booleanValue()) {
            OptionInstance.TooltipSupplier tooltip = entry.hasTooltip ? b -> Tooltip.create((Component)Component.translatable((String)("emotecraft.otherconfig." + entry.getName() + ".tooltip"))) : OptionInstance.noTooltip();
            T t = entry.get();
            if (t instanceof Boolean) {
                Boolean b2 = (Boolean)t;
                options.addBig(OptionInstance.createBoolean((String)("emotecraft.otherconfig." + entry.getName()), (OptionInstance.TooltipSupplier)tooltip, (boolean)b2, aBoolean -> entry.set(aBoolean)));
            } else if (entry instanceof SerializableConfig.FloatConfigEntry) {
                SerializableConfig.FloatConfigEntry floatEntry = (SerializableConfig.FloatConfigEntry)entry;
                int mapSize = 1024;
                double range = floatEntry.max - floatEntry.min;
                DecimalFormat formatter = new DecimalFormat("0.00");
                Function<Integer, Double> i2d = integer -> (double)integer.intValue() / (double)mapSize * range + (double)floatEntry.min;
                Function<Double, Integer> d2i = aDouble -> (int)((aDouble - (double)floatEntry.min) / range * (double)mapSize);
                options.addBig(new OptionInstance("emotecraft.otherconfig." + floatEntry.getName(), tooltip, (component, object) -> Options.genericValueLabel((Component)component, (Component)Component.literal((String)formatter.format(floatEntry.getTextVal()))), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, mapSize), Codec.DOUBLE.xmap(d2i, i2d), (Object)d2i.apply(floatEntry.getConfigVal()), integer -> floatEntry.setConfigVal((Double)i2d.apply((Integer)integer))));
            } else if (entry instanceof SerializableConfig.EnumConfigEntry) {
                SerializableConfig.EnumConfigEntry enumEntry = (SerializableConfig.EnumConfigEntry)entry;
                this.addEnumEntry(options, tooltip, enumEntry);
            }
        }
    }

    private <T extends Enum<T>> void addEnumEntry(OptionsList options, OptionInstance.TooltipSupplier<?> tooltip, SerializableConfig.EnumConfigEntry<T> entry) {
        Class enumClass = entry.getEnumClass();
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        Codec codec = Codec.STRING.xmap(s -> Enum.valueOf(enumClass, s), Object::toString);
        options.addBig(new OptionInstance("emotecraft.otherconfig." + entry.getName(), tooltip, (component, value) -> Component.literal((String)value.name()), (OptionInstance.ValueSet)new OptionInstance.Enum(List.of(values), codec), codec, (Object)((Enum)entry.get()), entry::set));
    }

    private void resetAll(boolean bl) {
        if (bl) {
            PlatformTools.getConfig().iterate(SerializableConfig.ConfigEntry::resetToDefault);
        }
        this.minecraft.setScreen((Screen)this);
    }

    public void removed() {
        Serializer.INSTANCE.saveConfig();
    }
}

