/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget.preview.elemets;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import com.zigythebird.playeranimcore.easing.EasingType;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.PlayerPreview;
import io.github.kosmx.emotes.arch.screen.utils.EmotecraftTexture;
import io.github.kosmx.emotes.arch.screen.utils.WidgetOutliner;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import io.github.kosmx.emotes.arch.screen.widget.preview.PreviewFastChooseWidget;
import io.github.kosmx.emotes.main.EmoteHolder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.joml.Vector2f;

public abstract class PlayerChooseElement
extends PlayerPreview
implements IChooseElement {
    private static final Float2FloatFunction EASING_TRANSFORMER = EasingType.EASE_IN_CIRC.buildTransformer(null);
    protected final AbstractFastChooseWidget parent;
    protected final int id;
    private boolean isAnimFinishing;

    public PlayerChooseElement(AbstractFastChooseWidget parent, GameProfile profile, int id) {
        super(profile, 0, 0, 0, 0, false);
        this.mannequin.emotecraft$getEmote().muteNbs = true;
        this.parent = parent;
        this.id = id;
        this.tick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, this.isAnimFinishing ? mouseX : 0, this.isAnimFinishing ? mouseY : 0, partialTick);
    }

    protected abstract void updateRectangle(float var1);

    protected abstract void getDirectionVector(Vector2f var1);

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float f;
        boolean doHoverPart = this.parent.controller.doHoverPart(this);
        AbstractFastChooseWidget abstractFastChooseWidget = this.parent;
        if (abstractFastChooseWidget instanceof PreviewFastChooseWidget) {
            PreviewFastChooseWidget widget = (PreviewFastChooseWidget)abstractFastChooseWidget;
            f = widget.getAnimTime();
        } else {
            f = 0.0f;
        }
        float progress = f;
        float easedProgress = 1.0f - EASING_TRANSFORMER.get(progress);
        this.isAnimFinishing = easedProgress > 0.9f;
        this.updateRectangle(easedProgress);
        this.renderBackground(guiGraphics);
        if (this.isHoveredOrFocused() && doHoverPart) {
            this.renderHover(guiGraphics);
        }
        EmoteHolder emoteHolder = this.getEmote();
        if (this.parent.controller.supportsKeyboardNavigation() && emoteHolder != null) {
            this.renderTileId(guiGraphics, easedProgress);
        }
        if (emoteHolder != null && PlatformTools.getConfig().showIconsIfPossible.get().booleanValue() && emoteHolder.getIconIdentifier() != null) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, emoteHolder.getIconIdentifier(), this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 256, 256, 256, 256);
        } else if (emoteHolder != null || !PlatformTools.getConfig().showIconsIfPossible.get().booleanValue()) {
            super.renderWidget(guiGraphics, this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, partialTick);
        }
        if (this.isHoveredOrFocused() && emoteHolder != null) {
            this.setTooltip(Tooltip.create((Component)emoteHolder.name));
            this.setTooltipDelay(Duration.ZERO);
        } else {
            this.setTooltip(null);
        }
        if (this.isHovered()) {
            guiGraphics.requestCursor(this.isActive() && doHoverPart ? (emoteHolder != null ? CursorTypes.POINTING_HAND : CursorTypes.RESIZE_ALL) : CursorTypes.NOT_ALLOWED);
        }
    }

    protected void renderBackground(GuiGraphics guiGraphics) {
        Identifier texture = EmotecraftTexture.MENU_LIST_BACKGROUND.identifier(Minecraft.getInstance().level != null);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.getX() + 1, this.getY() + 1, (float)this.getRight(), (float)this.getBottom(), this.getWidth() - 2, this.getHeight() - 2, 32, 32);
        WidgetOutliner.renderOutline(guiGraphics, this, -1);
    }

    protected void renderHover(GuiGraphics guiGraphics) {
        guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), ARGB.color((int)128, (int)66, (int)66, (int)66));
    }

    protected void renderTileId(GuiGraphics gg, float easedProgress) {
        Vector2f dir = new Vector2f();
        this.getDirectionVector(dir);
        if (dir.x == 0.0f && dir.y == 0.0f) {
            return;
        }
        float inv = Mth.invSqrt((float)(dir.x * dir.x + dir.y * dir.y));
        float nx = dir.x * inv;
        float ny = dir.y * inv;
        float cx0 = (float)this.getX() + (float)this.getWidth() * 0.5f;
        float cy0 = (float)this.getY() + (float)this.getHeight() * 0.5f;
        float cx1 = (float)this.parent.getX() + (float)this.parent.getWidth() * 0.5f;
        float cy1 = (float)this.parent.getY() + (float)this.parent.getHeight() * 0.5f;
        float t = 1.0f - easedProgress;
        float cx = Mth.lerp((float)t, (float)cx0, (float)cx1);
        float cy = Mth.lerp((float)t, (float)cy0, (float)cy1);
        float halfW = (float)this.getWidth() * 0.5f;
        float halfH = (float)this.getHeight() * 0.5f;
        float edge = Math.min(halfW / Math.abs(nx), halfH / Math.abs(ny));
        float offset = edge + 14.0f + (float)Math.min(this.getWidth(), this.getHeight()) * 0.25f * t;
        float px = cx + nx * offset;
        float py = cy + ny * offset;
        Font font = Minecraft.getInstance().font;
        String s = Integer.toString(this.id + 1);
        int n = Math.round(px - (float)font.width(s) / 2.0f);
        Objects.requireNonNull(font);
        gg.drawString(font, s, n, Math.round(py - 9.0f / 2.0f), -1);
    }

    @Override
    public void removed() {
        this.mannequin.stopEmote();
    }

    @Override
    public boolean hasEmote() {
        return PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] != null;
    }

    @Override
    public EmoteHolder getEmote() {
        UUID uuid = PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id];
        if (uuid != null) {
            EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get(uuid);
            if (emote == null && this.parent.controller.doesShowInvalid()) {
                emote = new EmoteHolder.Empty(uuid);
            }
            return emote;
        }
        return null;
    }

    @Override
    public void clearEmote() {
        this.setEmote(null);
    }

    @Override
    public void setEmote(EmoteHolder emote) {
        PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] = emote == null ? null : emote.getUuid();
    }

    @Override
    public void tick() {
        EmoteHolder holder = this.getEmote();
        float previewTick = holder == null ? 1.0f : PlayerChooseElement.calculatePreviewTick(holder.getEmote());
        boolean shouldPlayAgain = holder == null || holder.getEmote().loopType().shouldPlayAgain(null, holder.getEmote());
        boolean updated = this.playAnimation(holder == null ? null : holder.getEmote(), shouldPlayAgain ? Animation.LoopType.DEFAULT : Animation.LoopType.LOOP, true, previewTick);
        super.pause(!updated && !this.isHoveredOrFocused());
        if (updated || this.isHoveredOrFocused()) {
            super.tick();
        }
    }

    protected static float calculatePreviewTick(Animation animation) {
        float returnToTick;
        ExtraAnimationData data = animation.data();
        if (data.has("previewTick")) {
            return ((Float)data.getRaw("previewTick")).floatValue();
        }
        if (animation.loopType().shouldPlayAgain(null, animation) && (returnToTick = animation.loopType().restartFromTick(null, animation)) > 0.0f) {
            return (animation.length() - returnToTick) / 2.0f;
        }
        return animation.length() / 2.0f;
    }

    protected boolean isValidClickButton(MouseButtonInfo button) {
        return this.parent.controller.isValidClickButton(button);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        if (super.mouseClicked(event, bl)) {
            return this.parent.controller.onClick(this, (InputWithModifiers)event, bl);
        }
        return false;
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (!this.parent.controller.doHoverPart(this)) {
            return;
        }
        PlayerChooseElement.playButtonClickSound((SoundManager)handler);
    }
}

