/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network.client;

import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.proxy.AbstractNetworkInstance;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.tools.ServiceLoaderUtil;
import io.github.kosmx.emotes.main.EmoteHolder;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClientNetwork
extends AbstractNetworkInstance {
    public static ClientNetwork INSTANCE = ServiceLoaderUtil.loadServices(ClientNetwork.class).findAny().orElseThrow();
    private boolean isConfiguredNormally;

    @Override
    public boolean isActive() {
        return this.isServerChannelOpen(NetworkPlatformTools.EMOTE_CHANNEL_ID.id());
    }

    @Override
    public void sendMessage(EmotePacket.Builder builder, @Nullable UUID target) throws IOException {
        if (target != null) {
            builder.configureTarget(target);
        }
        EmotePacket writer = builder.build();
        this.sendMessage(writer, null);
        if (writer.data.emoteData != null && writer.data.emoteData.data().has("song") && writer.data.skippedPackets.contains((byte)3)) {
            PlatformTools.addToast((Component)Component.translatable((String)"emotecraft.song_too_big_to_send"));
        }
    }

    @Override
    public void sendMessage(EmotePacket byteBuffer, @Nullable UUID target) {
        this.sendPlayPacket(EmotePacketPayload.playPacket(byteBuffer));
    }

    public abstract boolean isServerChannelOpen(Identifier var1);

    public abstract void sendPlayPacket(CustomPacketPayload var1);

    public void receiveStreamMessage(@NotNull EmotePacket packet, @Nullable Consumer<CustomPacketPayload> configPacketConsumer) throws IOException {
        CommonData.LOGGER.error("Streaming message received!");
    }

    public void receiveConfigMessage(@NotNull EmotePacket packet, @NotNull Consumer<CustomPacketPayload> consumer) throws IOException {
        if (packet.data.purpose == PacketTask.CONFIG) {
            this.setVersions(packet.data.versions);
            this.sendC2SConfig(p -> consumer.accept(EmotePacketPayload.playPacket(p.build())));
            this.isConfiguredNormally = true;
        } else if (packet.data.purpose == PacketTask.FILE) {
            EmoteHolder.addEmoteToList(packet.data.emoteData, (INetworkInstance)this);
        } else {
            CommonData.LOGGER.warn("Invalid emotes packet type in configuration phase: " + String.valueOf((Object)packet.data.purpose));
        }
    }

    @Deprecated
    public void configureOnPlay(@NotNull Consumer<CustomPacketPayload> consumer) {
        if (!this.isConfiguredNormally && this.isActive()) {
            CommonData.LOGGER.warn("The server failed to configure the client, attempting to configure...");
            this.sendC2SConfig(p -> consumer.accept(EmotePacketPayload.playPacket(p.build())));
        }
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.isConfiguredNormally = false;
    }

    @Override
    public int maxDataSize() {
        return super.maxDataSize() - 16;
    }
}

