/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.utils;

import com.google.common.base.Stopwatch;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.EmotecraftClientMod;
import io.github.kosmx.emotes.common.CommonData;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmoteListener
extends PackSelectionScreen.Watcher {
    public static final Component RELOADING_WAIT = Component.translatable((String)"emotecraft.reloading.wait");
    public static final Component RELOADING = Component.translatable((String)"emotecraft.reloading");
    private static final DecimalFormat FORMAT = new DecimalFormat("#0.000");
    private CompletableFuture<?> loader;

    protected EmoteListener(Path path) throws IOException {
        super(path);
    }

    @Nullable
    public static EmoteListener create(Path packPath) {
        try {
            return new EmoteListener(packPath);
        }
        catch (IOException ex) {
            CommonData.LOGGER.warn("Failed to initialize emote dir monitoring", (Throwable)ex);
            return null;
        }
    }

    public void load(Runnable onComplete, @NotNull Executor executor) {
        if (this.loader != null) {
            this.loader.cancel(true);
        }
        PlatformTools.addToast(RELOADING);
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.loader = ((CompletableFuture)EmotecraftClientMod.loadEmotes().thenRun(() -> PlatformTools.addToast((Component)Component.translatable((String)"emotecraft.reloading.done", (Object[])new Object[]{FORMAT.format((double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0)})))).thenRunAsync(onComplete, Objects.requireNonNullElseGet(executor, Minecraft::getInstance));
    }

    public boolean isLoading() {
        return this.loader != null && !this.loader.isDone() && !this.loader.isCompletedExceptionally();
    }

    public void close() throws IOException {
        super.close();
        if (this.loader != null) {
            this.loader.cancel(true);
            this.loader = null;
        }
    }

    public void blockWhileLoading() {
        if (this.loader != null && !this.loader.isDone() && !this.loader.isCompletedExceptionally()) {
            try {
                this.loader.get(10L, TimeUnit.SECONDS);
            }
            catch (Throwable th) {
                CommonData.LOGGER.warn("Failed to wait for emote loading!", th);
                this.loader.cancel(true);
            }
        }
    }
}

