/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.utils;

import io.github.kosmx.emotes.arch.screen.utils.EmotecraftTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;

public class WidgetOutliner {
    public static void renderOutline(GuiGraphics guiGraphics, LayoutElement element, int color) {
        ResourceLocation headerSeparator = EmotecraftTexture.HEADER_SEPARATOR.identifier(Minecraft.getInstance().level != null);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, headerSeparator, element.getX(), element.getY() - 1, 0.0f, 0.0f, element.getWidth(), 2, 32, 2, color);
        WidgetOutliner.drawSeparatorRotated(guiGraphics, headerSeparator, element.getX() - 1, element.getY(), element.getHeight(), -90.0f, color);
        WidgetOutliner.drawSeparatorRotated(guiGraphics, headerSeparator, element.getX() + element.getWidth() + 1, element.getY(), element.getHeight(), 90.0f, color);
        ResourceLocation footerSeparator = EmotecraftTexture.FOOTER_SEPARATOR.identifier(Minecraft.getInstance().level != null);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, footerSeparator, element.getX(), element.getY() + element.getHeight() - 1, 0.0f, 0.0f, element.getWidth(), 2, 32, 2, color);
    }

    protected static void drawSeparatorRotated(GuiGraphics guiGraphics, ResourceLocation separator, int x, int y, int size, float angle, int color) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)x, (float)y + (float)size / 2.0f);
        guiGraphics.pose().rotate((float)Math.toRadians(angle));
        guiGraphics.pose().translate((float)(-size) / 2.0f, 0.0f);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, separator, 0, 0, 0.0f, 0.0f, size, 2, 32, 2, color);
        guiGraphics.pose().popMatrix();
    }
}

