/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.arch.network.neoforge.NetworkPlatformToolsImpl;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.mc.McUtils;
import java.util.Collection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class NetworkPlatformTools {
    public static final CustomPacketPayload.Type<EmotePacketPayload> EMOTE_CHANNEL_ID = new CustomPacketPayload.Type(McUtils.newIdentifier("emote"));
    public static final CustomPacketPayload.Type<EmotePacketPayload> STREAM_CHANNEL_ID = new CustomPacketPayload.Type(McUtils.newIdentifier("stream"));

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Contract
    @ExpectPlatform.Transformed
    public static boolean canSendPlay(ServerPlayer player, ResourceLocation channel) {
        void var1_1;
        return NetworkPlatformToolsImpl.canSendPlay(player, (ResourceLocation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Contract
    @ExpectPlatform.Transformed
    public static boolean canSendConfig(ServerConfigurationPacketListenerImpl player, ResourceLocation channel) {
        void var1_1;
        return NetworkPlatformToolsImpl.canSendConfig(player, (ResourceLocation)var1_1);
    }

    @ExpectPlatform
    @Contract
    @ExpectPlatform.Transformed
    public static Collection<ServerPlayer> getTrackedBy(Entity entity) {
        return NetworkPlatformToolsImpl.getTrackedBy(entity);
    }

    @NotNull
    public static Packet<?> createClientboundPacket(@NotNull CustomPacketPayload.Type<?> id, @NotNull EmotePacket packet) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)new EmotePacketPayload(id, packet));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getServer() {
        return NetworkPlatformToolsImpl.getServer();
    }

    @NotNull
    public static Packet<?> playPacket(@NotNull EmotePacket packet) {
        return NetworkPlatformTools.createClientboundPacket(EMOTE_CHANNEL_ID, packet);
    }

    @NotNull
    public static Packet<?> streamPacket(@NotNull EmotePacket packet) {
        return NetworkPlatformTools.createClientboundPacket(STREAM_CHANNEL_ID, packet);
    }
}

