/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.search.ISearchEngine;
import io.github.kosmx.emotes.arch.gui.widgets.search.VanillaSearch;
import io.github.kosmx.emotes.arch.screen.utils.BageUtils;
import io.github.kosmx.emotes.arch.screen.utils.PageButton;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.mc.McUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmoteListWidget
extends ObjectSelectionList<ListEntry> {
    private static final List<Component> LAST_OPENED_PATH = new CopyOnWriteArrayList<Component>();
    private final FolderEntry mainFolder = new FolderEntry((Component)Component.translatable((String)"emotecraft.folder.main"));
    private FolderEntry lastClickedFolder;
    private boolean compactMode;
    private final PageButton backButton = new PageButton(20, 20, RecipeBookPage.PAGE_BACKWARD_SPRITES, true, button -> {
        this.setLastFolder(null);
        if (this.lastClickedFolder == null) {
            this.setScrollAmount(0.0);
        } else {
            this.centerScrollOn((AbstractSelectionList.Entry)this.lastClickedFolder);
        }
    });

    public EmoteListWidget(Minecraft minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, width, height, y, itemHeight);
        this.centerListVertically = false;
        this.backButton.active = false;
    }

    public int getRowWidth() {
        if (this.compactMode) {
            return this.width;
        }
        return this.width / 2;
    }

    protected int scrollBarX() {
        if (!this.compactMode) {
            return super.scrollBarX();
        }
        return this.getX() + this.getRowWidth() - 6;
    }

    protected void renderSelection(GuiGraphics guiGraphics, ListEntry entry, int outerColor) {
        if (this.compactMode && this.scrollbarVisible()) {
            int j = entry.getX();
            int k = entry.getY();
            int l = j + entry.getWidth() - 8;
            int m = k + entry.getHeight();
            guiGraphics.fill(j, k, l, m, outerColor);
            guiGraphics.fill(j + 1, k + 1, l - 1, m - 1, -16777216);
        } else {
            super.renderSelection(guiGraphics, (AbstractSelectionList.Entry)entry, outerColor);
        }
    }

    protected void renderItem(GuiGraphics guiGraphics, int i, int j, float f, ListEntry entry) {
        try {
            super.renderItem(guiGraphics, i, j, f, (AbstractSelectionList.Entry)entry);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setEmotes(Iterable<EmoteHolder> list, boolean showInvalid) {
        Component folderName;
        ListEntry child;
        this.mainFolder.entries.clear();
        for (EmoteHolder emoteHolder : list) {
            if (emoteHolder.folder.isEmpty()) {
                this.mainFolder.entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
                continue;
            }
            this.createFoldersTree(emoteHolder.folder).entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
        }
        if (showInvalid) {
            for (EmoteHolder emoteHolder : this.getEmptyEmotes()) {
                this.mainFolder.entries.put(emoteHolder.name, new EmoteEntry(emoteHolder));
            }
        }
        this.filter(VanillaSearch.INSTANCE, false, "");
        Iterator<EmoteHolder> iterator = LAST_OPENED_PATH.iterator();
        while (iterator.hasNext() && (child = Objects.requireNonNullElse(this.lastClickedFolder, this.mainFolder).entries.get(folderName = (Component)iterator.next())) instanceof FolderEntry) {
            FolderEntry folder;
            this.lastClickedFolder = folder = (FolderEntry)child;
            this.setLastFolder(folder);
        }
    }

    public void filter(ISearchEngine engine, boolean isSearchActive, String search) {
        this.clearEntries();
        this.addEntry((AbstractSelectionList.Entry)new HeaderEntry(), 13);
        this.setSelected((ListEntry)null);
        engine.filter(this.getEmotes(isSearchActive).stream(), search).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        this.refreshScrollAmount();
    }

    public FolderEntry createFoldersTree(List<Component> folders) {
        FolderEntry last = this.mainFolder;
        for (Component folder : folders) {
            last = last.getOrCreateFolder(folder);
        }
        return last;
    }

    public Iterable<EmoteHolder> getEmptyEmotes() {
        LinkedList<EmoteHolder> empties = new LinkedList<EmoteHolder>();
        for (Pair<UUID, InputConstants.Key> pair : PlatformTools.getConfig().emoteKeyMap) {
            if (EmoteHolder.list.containsKey(pair.left())) continue;
            empties.add(new EmoteHolder.Empty((UUID)pair.left()));
        }
        return empties;
    }

    public List<ListEntry> getEmotes(boolean isSearchActive) {
        ArrayList<ListEntry> emotes = new ArrayList<ListEntry>();
        this.mainFolder.collectEmotes(isSearchActive, emotes);
        emotes.sort(ListEntry::compareTo);
        return Collections.unmodifiableList(emotes);
    }

    public void updateSize(int width, HeaderAndFooterLayout layout) {
        super.updateSize(width, layout);
        if (this.compactMode) {
            layout.arrangeElements();
            this.refreshScrollAmount();
        }
    }

    public void updateSizeAndPosition(int width, int height, int x, int y) {
        super.updateSizeAndPosition(this.compactMode ? width / 3 : width, height, x, y);
    }

    @Nullable
    public EmoteHolder getFocusedEmote() {
        AbstractSelectionList.Entry entry = this.getFocused();
        if (entry instanceof EmoteEntry) {
            EmoteEntry emote = (EmoteEntry)entry;
            return emote.getEmote();
        }
        return null;
    }

    @Nullable
    public ListEntry getHovered() {
        return (ListEntry)super.getHovered();
    }

    public void setSelected(@Nullable ListEntry selected) {
        super.setSelected((AbstractSelectionList.Entry)selected);
        if (selected instanceof FolderEntry) {
            FolderEntry folder;
            this.lastClickedFolder = folder = (FolderEntry)selected;
            this.setLastFolder(folder);
        }
    }

    public boolean setLastFolder(FolderEntry folder) {
        if (this.mainFolder.setLastFolder(folder)) {
            this.backButton.active = this.mainFolder.next != null;
            LAST_OPENED_PATH.clear();
            EmoteListWidget.updateLastOpenedPath(this.mainFolder.next);
            return true;
        }
        return false;
    }

    public void setCompactMode(boolean compactMode) {
        this.compactMode = compactMode;
    }

    public static MutableComponent appendScreenPath(FolderEntry folder, MutableComponent component) {
        component = component.append(McUtils.SLASH).append(CommonComponents.SPACE);
        if (folder.next != null) {
            return EmoteListWidget.appendScreenPath(folder.next, component.append(folder.name).append(CommonComponents.SPACE));
        }
        return component.append((Component)folder.name.copy().withStyle(style -> style.withBold(Boolean.valueOf(true))));
    }

    private static void updateLastOpenedPath(@Nullable FolderEntry folder) {
        if (folder == null) {
            return;
        }
        LAST_OPENED_PATH.add(folder.name);
        if (folder.next != null) {
            EmoteListWidget.updateLastOpenedPath(folder.next);
        }
    }

    public PageButton createBackButton() {
        return this.backButton;
    }

    public class FolderEntry
    extends ListEntry {
        public static final ResourceLocation FOLDER = McUtils.newIdentifier("textures/folder.png");
        public static final ResourceLocation FOLDER_OPEN = McUtils.newIdentifier("textures/folder_open.png");
        public static final Component FOLDER_DESC = Component.translatable((String)"emotecraft.folder");
        private final Map<Component, ListEntry> entries;
        private FolderEntry next;

        public FolderEntry(Component name) {
            super(name, FOLDER_DESC, Collections.emptyList());
            this.entries = new HashMap<Component, ListEntry>();
        }

        @Override
        public void renderAdditional(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float tickDelta) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, hovering ? FOLDER_OPEN : FOLDER, this.getX(), this.getContentY(), 0.0f, 0.0f, 32, 32, 32, 32);
        }

        @Override
        protected void collectEmotes(boolean isSearchActive, List<ListEntry> collection) {
            if (this.next == null || !this.entries.containsValue(this.next)) {
                for (ListEntry entry : this.entries.values()) {
                    if (entry instanceof FolderEntry) {
                        FolderEntry folder = (FolderEntry)entry;
                        boolean isInvalid = StringUtils.isBlank((CharSequence)this.name.getString());
                        if (!isInvalid) {
                            collection.add(folder);
                        }
                        if (!isSearchActive && !isInvalid) continue;
                        for (ListEntry folderEntry : folder.entries.values()) {
                            folderEntry.collectEmotes(isSearchActive, collection);
                        }
                        continue;
                    }
                    entry.collectEmotes(isSearchActive, collection);
                }
            } else {
                this.next.collectEmotes(isSearchActive, collection);
            }
        }

        public boolean setLastFolder(FolderEntry folder) {
            if (this.next != null) {
                if (folder == null && this.next.next == null) {
                    this.setSelectedFolder(null);
                    return true;
                }
                return this.next.setLastFolder(folder);
            }
            return this.setSelectedFolder(folder);
        }

        public boolean setSelectedFolder(FolderEntry folder) {
            if (folder == null || this.entries.containsValue(folder)) {
                this.next = folder;
                return true;
            }
            return false;
        }

        public FolderEntry getOrCreateFolder(Component name) {
            return (FolderEntry)this.entries.computeIfAbsent(name, x$0 -> new FolderEntry((Component)x$0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof FolderEntry)) return false;
            FolderEntry entry = (FolderEntry)obj;
            if (!this.name.equals((Object)entry.name)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            if (o instanceof FolderEntry) {
                return super.compareTo(o);
            }
            return -1;
        }
    }

    public abstract class ListEntry
    extends ObjectSelectionList.Entry<ListEntry>
    implements Comparable<ListEntry> {
        public final Component name;
        public final Component description;
        public final List<Component> bages;

        public ListEntry(Component name, Component description, List<Component> bages) {
            this.name = name;
            this.description = description;
            this.bages = bages;
        }

        public void renderContent(GuiGraphics matrices, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int maxX = this.getContentRight() - (EmoteListWidget.this.compactMode && EmoteListWidget.this.scrollbarVisible() ? 7 : 0);
            matrices.enableScissor(this.getX() - 1, this.getY() - 1, maxX, this.getY() + this.getHeight() + 1);
            if (hovered) {
                matrices.requestCursor(this.isFocused() ? CursorType.DEFAULT : CursorTypes.POINTING_HAND);
                matrices.fill(this.getContentX() - 1, this.getContentY() - 1, maxX, this.getContentBottom() + 1, ARGB.color((int)128, (int)66, (int)66, (int)66));
            }
            int maxBadgesWidth = Math.max(maxX - ((EmoteListWidget)EmoteListWidget.this).minecraft.font.width((FormattedText)this.name), maxX / 3) - (this.getContentX() + 31);
            int badgeWidth = BageUtils.drawBadges(matrices, ((EmoteListWidget)EmoteListWidget.this).minecraft.font, this.bages, maxX, this.getContentY(), maxBadgesWidth, true);
            Font font = ((EmoteListWidget)EmoteListWidget.this).minecraft.font;
            int n = this.getContentX() + 31;
            int n2 = this.getContentX() + 31;
            int n3 = this.getContentY();
            int n4 = this.getContentY();
            Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).minecraft.font);
            EmoteListWidget.renderScrollingString((GuiGraphics)matrices, (Font)font, (Component)this.name, (int)n, (int)n2, (int)n3, (int)(maxX - badgeWidth), (int)(n4 + 9), (int)-1);
            matrices.drawString(((EmoteListWidget)EmoteListWidget.this).minecraft.font, this.description, this.getContentX() + 31, this.getContentY() + 12, -8355712);
            this.renderAdditional(matrices, mouseX, mouseY, hovered, tickDelta);
            matrices.disableScissor();
        }

        public abstract void renderAdditional(GuiGraphics var1, int var2, int var3, boolean var4, float var5);

        @NotNull
        public Component getNarration() {
            return this.name;
        }

        public boolean matches(String string) {
            return this.name.getString().toLowerCase().contains(string.toLowerCase());
        }

        protected abstract void collectEmotes(boolean var1, List<ListEntry> var2);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        @Override
        public int compareTo(@NotNull ListEntry o) {
            return this.name.getString().compareTo(o.name.getString());
        }
    }

    public class EmoteEntry
    extends ListEntry {
        public final EmoteHolder emote;

        public EmoteEntry(EmoteHolder emote) {
            super(emote.name, emote.description, emote.bages);
            this.emote = emote;
        }

        @Override
        public void renderAdditional(GuiGraphics matrices, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ResourceLocation texture;
            if (!this.emote.author.getString().isEmpty()) {
                MutableComponent text = Component.translatable((String)"emotecraft.emote.author").withStyle(ChatFormatting.GOLD).append(this.emote.author);
                matrices.drawString(((EmoteListWidget)EmoteListWidget.this).minecraft.font, (Component)text, this.getContentX() + 31, this.getContentY() + 23, -8355712);
            }
            if ((texture = this.emote.getIconIdentifier()) != null) {
                GlStateManager._enableBlend();
                matrices.blit(RenderPipelines.GUI_TEXTURED, texture, this.getContentX(), this.getContentY(), 0.0f, 0.0f, 32, 32, 256, 256, 256, 256);
                GlStateManager._disableBlend();
            }
        }

        public EmoteHolder getEmote() {
            return this.emote;
        }

        @Override
        @NotNull
        public Component getNarration() {
            return this.emote.name;
        }

        @Override
        public boolean matches(String string) {
            return super.matches(string) || this.description.getString().toLowerCase().contains(string.toLowerCase()) || this.emote.fileName != null && this.emote.fileName.getString().toLowerCase().contains(string.toLowerCase()) || this.emote.author.getString().equalsIgnoreCase(string);
        }

        @Override
        protected void collectEmotes(boolean excludeFolders, List<ListEntry> collection) {
            collection.add(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EmoteEntry)) return false;
            EmoteEntry entry = (EmoteEntry)obj;
            if (!this.emote.equals(entry.emote)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.emote.hashCode();
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            if (o instanceof EmoteEntry) {
                return super.compareTo(o);
            }
            return 1;
        }
    }

    public class HeaderEntry
    extends ListEntry {
        public HeaderEntry() {
            super(CommonComponents.EMPTY, CommonComponents.EMPTY, Collections.emptyList());
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            MutableComponent path = EmoteListWidget.appendScreenPath(EmoteListWidget.this.mainFolder, Component.empty());
            if (EmoteListWidget.this.compactMode) {
                Font font = ((EmoteListWidget)EmoteListWidget.this).minecraft.font;
                int n = this.getContentX();
                int n2 = this.getContentX();
                int n3 = this.getContentY();
                int n4 = this.getContentRight();
                int n5 = this.getContentY();
                Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).minecraft.font);
                EmoteListWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)((Component)path), (int)n, (int)n2, (int)n3, (int)n4, (int)(n5 + 9), (int)-1);
            } else {
                Font font = ((EmoteListWidget)EmoteListWidget.this).minecraft.font;
                int n = this.getContentX();
                int n6 = this.getContentY();
                int n7 = this.getContentRight();
                int n8 = this.getContentY();
                Objects.requireNonNull(((EmoteListWidget)EmoteListWidget.this).minecraft.font);
                EmoteListWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)((Component)path), (int)n, (int)n6, (int)n7, (int)(n8 + 9), (int)-1);
            }
        }

        @Override
        public void renderAdditional(GuiGraphics matrices, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        }

        @Override
        protected void collectEmotes(boolean isSearchActive, List<ListEntry> collection) {
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof HeaderEntry;
        }

        @Override
        public int hashCode() {
            return 984359084;
        }

        @Override
        public int compareTo(@NotNull ListEntry o) {
            return 1;
        }

        @Override
        public boolean matches(String string) {
            return false;
        }
    }
}

