/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network;

import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.DiscoveryPacket;
import io.github.kosmx.emotes.common.network.objects.EmoteDataPacket;
import io.github.kosmx.emotes.common.network.objects.EmoteHeaderPacket;
import io.github.kosmx.emotes.common.network.objects.EmoteIconPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.common.network.objects.NetHashMap;
import io.github.kosmx.emotes.common.network.objects.NewAnimPacket;
import io.github.kosmx.emotes.common.network.objects.PlayerDataPacket;
import io.github.kosmx.emotes.common.network.objects.SongPacket;
import io.github.kosmx.emotes.common.network.objects.StopPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import it.unimi.dsi.fastutil.bytes.Byte2ByteMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteOpenHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmotePacket {
    public static final Byte2ByteMap defaultVersions = new Byte2ByteOpenHashMap();
    private static final NetHashMap SUB_PACKETS;
    public final NetData data;

    private EmotePacket(@NotNull NetData data) {
        if (data.versions.isEmpty()) {
            data.versions.putAll((Map<Byte, Byte>)defaultVersions);
        }
        this.data = data;
    }

    public EmotePacket(@NotNull ByteBuf byteBuf) {
        if (byteBuf.readInt() > 8) {
            throw new RuntimeException("Can't read newer version");
        }
        this.data = new NetData();
        this.data.purpose = PacketTask.getTaskFromID(byteBuf.readByte());
        int count = byteBuf.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            AbstractNetworkPacket packet = (AbstractNetworkPacket)SUB_PACKETS.get(byteBuf.readByte());
            byte subVersion = byteBuf.readByte();
            int size = byteBuf.readInt();
            int currentPos = byteBuf.readerIndex();
            if (packet != null) {
                try {
                    packet.read(byteBuf, this.data, subVersion);
                }
                catch (Throwable th) {
                    if (packet.isOptional()) {
                        CommonData.LOGGER.warn("Invalid {} sub-packet received!", (Object)packet, (Object)th);
                    }
                    throw new RuntimeException("Invalid " + String.valueOf(packet) + " sub-packet received", th);
                }
                if (byteBuf.readerIndex() == size + currentPos) continue;
                byteBuf.readerIndex(currentPos + size);
                continue;
            }
            byteBuf.readerIndex(currentPos + size);
        }
        if (!this.data.prepareAndValidate()) {
            throw new RuntimeException("no valid data");
        }
    }

    public void write(ByteBuf buf) {
        this.write(buf, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    }

    public void write(ByteBuf buf, ByteBufAllocator allocator) {
        if (this.data.purpose == PacketTask.UNKNOWN) {
            throw new IllegalArgumentException("Can't send packet without any purpose...");
        }
        int sizeSum = 6;
        ArrayList<ByteBuf> writable = new ArrayList<ByteBuf>();
        try {
            for (AbstractNetworkPacket packet : SUB_PACKETS.values()) {
                if (!packet.doWrite(this.data)) continue;
                boolean optional = packet.isOptional();
                ByteBuf packetBuff = null;
                try {
                    packetBuff = this.writeSubPacket(packet, allocator);
                }
                catch (IOException ex) {
                    if (optional) {
                        CommonData.LOGGER.warn("Exception while writing {} sub-packet!", (Object)packet, (Object)ex);
                    }
                    throw ex;
                }
                if (packetBuff == null) continue;
                int subPacketSize = packetBuff.readableBytes();
                if (!optional || sizeSum + subPacketSize <= this.data.sizeLimit) {
                    writable.add(packetBuff);
                    sizeSum += subPacketSize;
                    continue;
                }
                this.data.skippedPackets.add(packet.getID());
                CommonData.LOGGER.warn("Writing {} skipped!", (Object)packet);
                packetBuff.release();
            }
            if (this.data.strictSizeLimit && sizeSum > this.data.sizeLimit) {
                throw new RuntimeException(String.format("Can't send emote, packet's size (%s) is bigger than max allowed (%s)!", sizeSum, this.data.sizeLimit));
            }
            buf.writeInt((int)this.data.versions.getOrDefault((byte)8, (byte)8).byteValue());
            buf.writeByte((int)this.data.purpose.id);
            buf.writeByte(writable.size());
            for (ByteBuf byteBuf : writable) {
                buf.writeBytes(byteBuf);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            for (ByteBuf byteBuf : writable) {
                byteBuf.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf writeSubPacket(AbstractNetworkPacket packet, ByteBufAllocator allocator) throws IOException {
        byte packetVersion = packet.getVer(this.data.versions);
        ByteBuf packetContent = allocator.buffer();
        try {
            packet.write(packetContent, this.data, packetVersion);
            ByteBuf byteBuf = allocator.buffer(packetContent.readableBytes() + 6);
            byteBuf.writeByte((int)packet.getID());
            byteBuf.writeByte((int)packetVersion);
            byteBuf.writeInt(packetContent.readableBytes());
            byteBuf.writeBytes(packetContent);
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            packetContent.release();
        }
    }

    static {
        AbstractNetworkPacket tmp = new NewAnimPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new EmoteDataPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new PlayerDataPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new DiscoveryPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new StopPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new SongPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new EmoteHeaderPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        tmp = new EmoteIconPacket();
        defaultVersions.put(tmp.getID(), tmp.getVer());
        SUB_PACKETS = new NetHashMap(new DiscoveryPacket(), new NewAnimPacket(), new EmoteDataPacket(), new PlayerDataPacket(), new StopPacket(), new EmoteHeaderPacket(), new SongPacket(), new EmoteIconPacket());
    }

    public record Builder(NetData data) {
        private final NetData data;

        public Builder() {
            this(new NetData());
        }

        public Builder setVersion(Map<Byte, Byte> versions) {
            this.data.versions.clear();
            this.data.versions.putAll(versions);
            return this;
        }

        public NetData data() {
            return this.data.copy();
        }

        public Builder copy() {
            return new Builder(this.data.copy());
        }

        public EmotePacket build() {
            return new EmotePacket(this.data);
        }

        public EmotePacket build(int sizeLimit, boolean strict) {
            return this.setSizeLimit(sizeLimit, strict).build();
        }

        public Builder setSizeLimit(int sizeLimit, boolean strict) {
            if (sizeLimit <= 0) {
                throw new IllegalArgumentException("Size limit must be positive");
            }
            this.data.sizeLimit = sizeLimit;
            this.data.strictSizeLimit = strict;
            return this;
        }

        public Builder configureToStreamEmote(Animation emoteData, @Nullable UUID player) {
            if (this.data.purpose != PacketTask.UNKNOWN) {
                throw new IllegalArgumentException("Can't send and stop emote at the same time");
            }
            this.data.purpose = PacketTask.STREAM;
            this.data.emoteData = emoteData;
            this.data.player = player;
            return this;
        }

        public Builder configureToSaveEmote(Animation emoteData) {
            if (this.data.purpose != PacketTask.UNKNOWN) {
                throw new IllegalArgumentException("already configured?!");
            }
            this.data.purpose = PacketTask.FILE;
            this.data.sizeLimit = Integer.MAX_VALUE;
            this.data.emoteData = emoteData;
            return this;
        }

        public Builder configureEmoteTick(float tick) {
            this.data.tick = tick;
            return this;
        }

        public Builder configureTarget(@Nullable UUID target) {
            this.data.player = target;
            return this;
        }

        public Builder configureToStreamEmote(Animation emoteData) {
            return this.configureToStreamEmote(emoteData, null);
        }

        public Builder configureToSendStop(UUID emoteID, @Nullable UUID player) {
            if (this.data.purpose != PacketTask.UNKNOWN) {
                throw new IllegalArgumentException("Can't send emote and stop at the same time");
            }
            this.data.purpose = PacketTask.STOP;
            this.data.stopEmoteID = emoteID;
            this.data.player = player;
            return this;
        }

        public Builder configureToSendStop(UUID emoteID) {
            return this.configureToSendStop(emoteID, null);
        }

        public Builder configureToConfigExchange() {
            if (this.data.purpose != PacketTask.UNKNOWN) {
                throw new IllegalArgumentException("Can't send config with emote or stop data...");
            }
            this.data.purpose = PacketTask.CONFIG;
            this.setVersion((Map<Byte, Byte>)defaultVersions);
            return this;
        }

        public void removePlayerID() {
            this.data.player = null;
        }

        public Builder strictSizeLimit(boolean strict) {
            this.data.strictSizeLimit = strict;
            return this;
        }
    }
}

