/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.neoforge.services;

import io.github.kosmx.emotes.mc.ServerCommands;
import io.github.kosmx.emotes.mc.services.IPermissionService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="emotecraft", value={Dist.DEDICATED_SERVER})
public class NeoPermissionService
implements IPermissionService {
    private static final Map<String, PermissionNode<Boolean>> NODES = new HashMap<String, PermissionNode<Boolean>>();

    @Override
    public Optional<Boolean> getPermissionValue(@NotNull CommandSourceStack source, @NotNull String permission) {
        if (!NODES.containsKey(permission) || !source.isPlayer()) {
            return Optional.empty();
        }
        return Optional.of((Boolean)PermissionAPI.getPermission((ServerPlayer)Objects.requireNonNull(source.getPlayer()), NODES.get(permission), (PermissionDynamicContext[])new PermissionDynamicContext[0]));
    }

    @Override
    public boolean isActive() {
        return FMLLoader.getDist().isDedicatedServer();
    }

    @SubscribeEvent
    public static void onRegisterPermissionNodes(PermissionGatherEvent.Nodes event) {
        for (String permission : ServerCommands.PERMISSIONS) {
            PermissionNode node = new PermissionNode("emotecraft", permission, PermissionTypes.BOOLEAN, (arg, uUID, permissionDynamicContexts) -> false, new PermissionDynamicContextKey[0]);
            event.addNodes(new PermissionNode[]{node});
            NODES.put(permission, (PermissionNode<Boolean>)node);
        }
    }
}

