/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.mc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.api.events.server.ServerEmoteAPI;
import io.github.kosmx.emotes.mc.EmoteArgumentProvider;
import io.github.kosmx.emotes.mc.services.IPermissionService;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;

public final class ServerCommands {
    public static final List<String> PERMISSIONS = List.of("emotes.play.player", "emotes.stop.player", "emotes.stop.forced", "emotes.play.showhidden", "emotes.reload");

    public static <T> void register(CommandDispatcher<T> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        ServerCommands.register(dispatcher, environment == Commands.CommandSelection.DEDICATED);
    }

    public static <T> void register(CommandDispatcher<T> dispatcher, boolean isDedicated) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"emotes").then(Commands.literal((String)"play").then(((RequiredArgumentBuilder)Commands.argument((String)"emote", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EmoteArgumentProvider(ServerCommands::getEmotes)).executes(context -> {
            UUID player = ((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID();
            boolean admin = IPermissionService.INSTANCE.check((CommandSourceStack)context.getSource(), "emotes.stop.forced", 2);
            Animation emote = EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<CommandSourceStack>)context), (CommandContext<CommandSourceStack>)context, "emote");
            if (!admin && ServerEmoteAPI.isForcedEmote(player)) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Can't stop forced emote without admin rights")).create();
            }
            ServerEmoteAPI.playEmote(player, emote, false);
            return 0;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).requires(IPermissionService.INSTANCE.require("emotes.play.player", 2))).executes(context -> {
            ServerEmoteAPI.playEmote(EntityArgument.getPlayer((CommandContext)context, (String)"player").getUUID(), EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<CommandSourceStack>)context), (CommandContext<CommandSourceStack>)context, "emote"), false);
            return 0;
        })).then(Commands.argument((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerEmoteAPI.playEmote(EntityArgument.getPlayer((CommandContext)context, (String)"player").getUUID(), EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<CommandSourceStack>)context), (CommandContext<CommandSourceStack>)context, "emote"), BoolArgumentType.getBool((CommandContext)context, (String)"forced"));
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.literal((String)"stop").executes(context -> {
            boolean canStop;
            boolean admin = IPermissionService.INSTANCE.check((CommandSourceStack)context.getSource(), "emotes.stop.forced", 2);
            UUID player = ((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID();
            boolean bl = canStop = admin || !ServerEmoteAPI.isForcedEmote(player);
            if (canStop) {
                ServerEmoteAPI.playEmote(player, null, false);
                return 0;
            }
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Can't stop forced emote without admin rights")).create();
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).requires(IPermissionService.INSTANCE.require("emotes.stop.player", 2))).executes(context -> {
            ServerEmoteAPI.playEmote(EntityArgument.getPlayer((CommandContext)context, (String)"player").getUUID(), null, false);
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(ctx -> IPermissionService.INSTANCE.check((CommandSourceStack)ctx, "emotes.reload", 4) && isDedicated)).executes(context -> {
            UniversalEmoteSerializer.loadEmotes();
            return 0;
        })));
    }

    private static Map<UUID, Animation> getEmotes(CommandContext<CommandSourceStack> context) {
        return IPermissionService.INSTANCE.check((CommandSourceStack)context.getSource(), "emotes.play.showhidden", 1) ? UniversalEmoteSerializer.getLoadedEmotes() : UniversalEmoteSerializer.SERVER_EMOTES;
    }
}

