/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget.preview.elemets;

import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.PlayerPreview;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import io.github.kosmx.emotes.main.EmoteHolder;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;

public abstract class PlayerChooseElement
extends PlayerPreview
implements IChooseElement {
    protected final AbstractFastChooseWidget parent;
    protected final int id;

    public PlayerChooseElement(AbstractFastChooseWidget parent, GameProfile profile, int id) {
        super(profile, 0, 0, 0, 0, false);
        this.player.emotecraft$getEmote().muteNbs = true;
        this.parent = parent;
        this.id = id;
        this.tick();
    }

    protected abstract void updateRectangle();

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.isHovered = this.isHovered && this.parent.controller.doHoverPart(this);
        this.updateRectangle();
        if (this.isHoveredOrFocused()) {
            this.renderHover(guiGraphics);
        }
        EmoteHolder emoteHolder = this.getEmote();
        super.renderWidget(guiGraphics, this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, partialTick);
        if (this.isHoveredOrFocused() && emoteHolder != null) {
            this.setTooltip(Tooltip.create((Component)emoteHolder.name));
            this.setTooltipDelay(Duration.ZERO);
        } else {
            this.setTooltip(null);
        }
    }

    protected abstract void renderHover(GuiGraphics var1);

    @Override
    public void removed() {
        this.player.stopEmote();
    }

    @Override
    public boolean hasEmote() {
        return PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] != null;
    }

    @Override
    public EmoteHolder getEmote() {
        UUID uuid = PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id];
        if (uuid != null) {
            EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get(uuid);
            if (emote == null && this.parent.controller.doesShowInvalid()) {
                emote = new EmoteHolder.Empty(uuid);
            }
            return emote;
        }
        return null;
    }

    @Override
    public void clearEmote() {
        this.setEmote(null);
    }

    @Override
    public void setEmote(EmoteHolder emote) {
        PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] = emote == null ? null : emote.getUuid();
    }

    @Override
    public void tick() {
        EmoteHolder holder = this.getEmote();
        float previewTick = holder == null ? 1.0f : PlayerChooseElement.calculatePreviewTick(holder.getEmote());
        boolean shouldPlayAgain = holder == null || holder.getEmote().loopType().shouldPlayAgain(null, holder.getEmote());
        boolean updated = this.playAnimation(holder == null ? null : holder.getEmote(), shouldPlayAgain ? Animation.LoopType.DEFAULT : Animation.LoopType.LOOP, true, previewTick);
        super.pause(!updated && !this.isHoveredOrFocused());
        if (updated || this.isHoveredOrFocused()) {
            super.tick();
        }
    }

    protected static float calculatePreviewTick(Animation animation) {
        float returnToTick;
        ExtraAnimationData data = animation.data();
        if (data.has("previewTick")) {
            return ((Float)data.getRaw("previewTick")).floatValue();
        }
        if (animation.loopType().shouldPlayAgain(null, animation) && (returnToTick = animation.loopType().restartFromTick(null, animation)) > 0.0f) {
            return (animation.length() - returnToTick) / 2.0f;
        }
        return animation.length() / 2.0f;
    }

    protected boolean isValidClickButton(int button) {
        return this.parent.controller.isValidClickButton(button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return this.parent.controller.onClick(this, button);
        }
        return false;
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (!this.parent.controller.doHoverPart(this)) {
            return;
        }
        PlayerChooseElement.playButtonClickSound((SoundManager)handler);
    }
}

