/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget;

import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.utils.PageButton;
import io.github.kosmx.emotes.arch.screen.widget.FastChooseController;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFastChooseWidget
extends AbstractWidget
implements ContainerEventHandler {
    protected final List<AbstractWidget> elements = new ArrayList<AbstractWidget>();
    public final FastChooseController controller;
    @Nullable
    private GuiEventListener focused;
    private boolean isDragging;
    protected final PageButton forwardButton = new PageButton(RecipeBookPage.PAGE_FORWARD_SPRITES, false, this::onForwardButton);
    protected final PageButton backButton = new PageButton(RecipeBookPage.PAGE_BACKWARD_SPRITES, false, this::onBackButton);
    private static int currentPage;
    private double scrollAccumulator = 0.0;

    protected AbstractFastChooseWidget(FastChooseController controller, int x, int y, int size, Component message) {
        super(x, y, size, size, message);
        this.controller = controller;
        this.elements.add((AbstractWidget)this.forwardButton);
        this.elements.add((AbstractWidget)this.backButton);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.getX() + this.getWidth() / 2;
        int centerY = this.getY() + this.getHeight() / 2;
        MutableComponent text = Component.literal((String)String.valueOf(this.getCurrentPage() + 1));
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width((FormattedText)text);
        int buttonPadding = Math.max((12 + textWidth) / 2 + 2, this.globalPadding());
        this.forwardButton.setPosition(centerX - this.forwardButton.getWidth() / 2 + buttonPadding, centerY - this.forwardButton.getHeight() / 2);
        this.backButton.setPosition(centerX - this.backButton.getWidth() / 2 - buttonPadding, centerY - this.backButton.getHeight() / 2);
        int n = centerX - textWidth / 2;
        Objects.requireNonNull(font);
        guiGraphics.drawString(font, (Component)text, n, centerY - 9 / 2, -1);
        for (Renderable renderable : this.elements) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public int globalPadding() {
        return Math.min(this.getWidth() / 8, this.getHeight() / 8);
    }

    public abstract void tick();

    public void removed() {
        for (AbstractWidget widget : this.elements) {
            if (!(widget instanceof IChooseElement)) continue;
            IChooseElement element = (IChooseElement)widget;
            element.removed();
        }
    }

    @NotNull
    public List<AbstractWidget> children() {
        return this.elements;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (focused != null) {
            focused.setFocused(true);
        }
        this.focused = focused;
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public void setSize(int size) {
        this.setSize(size, size);
    }

    public void playDownSound(SoundManager handler) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void onForwardButton(PageButton button) {
        currentPage = currentPage < PlatformTools.getConfig().fastMenuEmotes.length - 1 ? ++currentPage : 0;
    }

    protected void onBackButton(PageButton button) {
        currentPage = currentPage > 0 ? --currentPage : PlatformTools.getConfig().fastMenuEmotes.length - 1;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        boolean ret = super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        this.scrollAccumulator += scrollX;
        int maxPages = PlatformTools.getConfig().fastMenuEmotes.length;
        while (this.scrollAccumulator >= 2.0) {
            this.scrollAccumulator -= 2.0;
            currentPage = (currentPage + 1) % maxPages;
            ret = true;
        }
        while (this.scrollAccumulator <= -2.0) {
            this.scrollAccumulator += 2.0;
            currentPage = (currentPage - 1 + maxPages) % maxPages;
            ret = true;
        }
        return ret;
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        return super.nextFocusPath(event);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        super.mouseReleased(mouseX, mouseY, button);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean isFocused() {
        return super.isFocused();
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
    }
}

