/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.arch.network.EmotesMixinNetwork;
import io.github.kosmx.emotes.arch.network.ModdedServerPlayNetwork;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;

public final class CommonServerNetworkHandler
extends AbstractServerEmotePlay<ModdedServerPlayNetwork> {
    @Override
    public void receiveMessage(byte[] bytes, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            try {
                this.receiveMessage(bytes, CommonServerNetworkHandler.getHandler(serverPlayer.connection));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ModdedServerPlayNetwork getHandler(ServerGamePacketListenerImpl handler) {
        return ((EmotesMixinNetwork)handler).emotecraft$getServerNetworkInstance();
    }

    public void receiveStreamMessage(byte[] bytes, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.receiveStreamMessage(serverPlayer, CommonServerNetworkHandler.getHandler(serverPlayer.connection), ByteBuffer.wrap(bytes));
        }
    }

    public void receiveStreamMessage(ServerPlayer player, ModdedServerPlayNetwork handler, ByteBuffer buf) {
        player.connection.disconnect((Component)Component.literal((String)"This server does not support streaming!"));
    }

    @Override
    protected UUID getUUIDFromPlayer(ModdedServerPlayNetwork player) {
        return player.serverGamePacketListener.getPlayer().getUUID();
    }

    @Override
    protected ModdedServerPlayNetwork getPlayerFromUUID(UUID player) {
        return this.getPlayerNetworkInstance(NetworkPlatformTools.getServer().getPlayerList().getPlayer(player));
    }

    public ModdedServerPlayNetwork getPlayerNetworkInstance(ServerPlayer player) {
        return ((EmotesMixinNetwork)player.connection).emotecraft$getServerNetworkInstance();
    }

    @Override
    protected void sendForEveryoneElse(NetData data, ModdedServerPlayNetwork player) {
        for (ServerPlayer target : NetworkPlatformTools.getTrackedBy(player.serverGamePacketListener.getPlayer())) {
            ModdedServerPlayNetwork targetInstance = this.getPlayerNetworkInstance(target);
            if (targetInstance == player || !NetworkPlatformTools.canSendPlay(target, NetworkPlatformTools.EMOTE_CHANNEL_ID.id())) continue;
            this.sendForPlayer(data, player, targetInstance);
        }
    }

    public static CommonServerNetworkHandler getInstance() {
        return (CommonServerNetworkHandler)AbstractServerEmotePlay.getInstance();
    }
}

