/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.mc;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.api.events.server.ServerEmoteAPI;
import io.github.kosmx.emotes.mc.EmoteArgumentProvider;
import io.github.kosmx.emotes.mc.services.IPermissionService;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;

public final class ServerCommands {
    public static final List<String> PERMISSIONS = List.of("emotes.play.player", "emotes.stop.player", "emotes.stop.forced", "emotes.play.showhidden", "emotes.reload");

    public static <T> void register(CommandDispatcher<T> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        ServerCommands.register(dispatcher, environment == Commands.CommandSelection.DEDICATED);
    }

    public static <T> void register(CommandDispatcher<T> dispatcher, boolean isDedicated) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"emotes").then(Commands.literal((String)"play").then(((RequiredArgumentBuilder)Commands.argument((String)"emote", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EmoteArgumentProvider(ServerCommands::getEmotes)).executes(context -> {
            UUID player = ((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID();
            boolean admin = IPermissionService.INSTANCE.check((CommandSourceStack)context.getSource(), "emotes.stop.forced", PermissionLevel.GAMEMASTERS);
            if (!admin && ServerEmoteAPI.isForcedEmote((UUID)player)) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Can't stop forced emote without admin rights")).create();
            }
            Animation emote = EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<CommandSourceStack>)context), (CommandContext<CommandSourceStack>)context, "emote");
            ServerEmoteAPI.playEmote((UUID)player, (Animation)emote, (boolean)false);
            return 0;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"avatar", (ArgumentType)EntityArgument.entities()).requires(IPermissionService.INSTANCE.require("emotes.play.player", PermissionLevel.MODERATORS))).executes(context -> {
            ServerEmoteAPI.playEmote((UUID)ServerCommands.getAvatar((CommandContext<CommandSourceStack>)context, "avatar").getUUID(), (Animation)EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<CommandSourceStack>)context), (CommandContext<CommandSourceStack>)context, "emote"), (boolean)false);
            return 0;
        })).then(Commands.argument((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerEmoteAPI.playEmote((UUID)ServerCommands.getAvatar((CommandContext<CommandSourceStack>)context, "avatar").getUUID(), (Animation)EmoteArgumentProvider.getEmote(ServerCommands.getEmotes((CommandContext<CommandSourceStack>)context), (CommandContext<CommandSourceStack>)context, "emote"), (boolean)BoolArgumentType.getBool((CommandContext)context, (String)"forced"));
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.literal((String)"stop").executes(context -> {
            boolean admin = IPermissionService.INSTANCE.check((CommandSourceStack)context.getSource(), "emotes.stop.forced", PermissionLevel.GAMEMASTERS);
            UUID player = ((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID();
            if (admin || !ServerEmoteAPI.isForcedEmote((UUID)player)) {
                ServerEmoteAPI.playEmote((UUID)player, null, (boolean)false);
                return 0;
            }
            throw new SimpleCommandExceptionType((Message)Component.literal((String)"Can't stop forced emote without admin rights")).create();
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"avatar", (ArgumentType)EntityArgument.entity()).requires(IPermissionService.INSTANCE.require("emotes.stop.player", PermissionLevel.MODERATORS))).executes(context -> {
            ServerEmoteAPI.playEmote((UUID)ServerCommands.getAvatar((CommandContext<CommandSourceStack>)context, "avatar").getUUID(), null, (boolean)false);
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(ctx -> IPermissionService.INSTANCE.check((CommandSourceStack)ctx, "emotes.reload", PermissionLevel.ADMINS) && isDedicated)).executes(context -> {
            UniversalEmoteSerializer.loadEmotes();
            return 0;
        })));
    }

    private static Map<UUID, Animation> getEmotes(CommandContext<CommandSourceStack> context) {
        return IPermissionService.INSTANCE.check((CommandSourceStack)context.getSource(), "emotes.play.showhidden", PermissionLevel.MODERATORS) ? UniversalEmoteSerializer.getLoadedEmotes() : UniversalEmoteSerializer.SERVER_EMOTES;
    }

    public static Avatar getAvatar(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)name);
        if (entity instanceof Avatar) {
            Avatar avatar = (Avatar)entity;
            return avatar;
        }
        throw new SimpleCommandExceptionType((Message)Component.literal((String)"The specified entity must be an avatar!")).create();
    }
}

