/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CaseInsensitiveStringHashMap<V>
extends HashMap<String, V> {
    private Set<String> keySet;
    private Set<Map.Entry<String, V>> entrySet;

    public CaseInsensitiveStringHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CaseInsensitiveStringHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public CaseInsensitiveStringHashMap() {
    }

    public CaseInsensitiveStringHashMap(Map<String, ? extends V> m) {
        super(CaseInsensitiveStringHashMap.lowercaseMap(m));
    }

    private static <T> T lowercase(T key) {
        return (T)(key instanceof String ? ((String)key).toLowerCase(Locale.ROOT) : key);
    }

    private static <V> Map<? extends String, ? extends V> lowercaseMap(Map<? extends String, ? extends V> m) {
        HashMap<String, V> lowercased = new HashMap<String, V>();
        for (Map.Entry<String, V> entry : m.entrySet()) {
            lowercased.put(CaseInsensitiveStringHashMap.lowercase(entry.getKey()), entry.getValue());
        }
        return lowercased;
    }

    @Override
    public V get(Object key) {
        return super.get(CaseInsensitiveStringHashMap.lowercase(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(CaseInsensitiveStringHashMap.lowercase(key));
    }

    @Override
    public V put(String key, V value) {
        return super.put(CaseInsensitiveStringHashMap.lowercase(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        super.putAll(CaseInsensitiveStringHashMap.lowercaseMap(m));
    }

    @Override
    public V remove(Object key) {
        return super.remove(CaseInsensitiveStringHashMap.lowercase(key));
    }

    @Override
    public Set<String> keySet() {
        CaseInsensitiveKeySet ks = this.keySet;
        if (ks == null) {
            this.keySet = ks = new CaseInsensitiveKeySet(super.keySet());
        }
        return ks;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        CaseInsensitiveEntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new CaseInsensitiveEntrySet(super.entrySet())) : es;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return super.getOrDefault(CaseInsensitiveStringHashMap.lowercase(key), defaultValue);
    }

    @Override
    public V putIfAbsent(String key, V value) {
        return super.putIfAbsent(CaseInsensitiveStringHashMap.lowercase(key), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return super.remove(CaseInsensitiveStringHashMap.lowercase(key), value);
    }

    @Override
    public boolean replace(String key, V oldValue, V newValue) {
        return super.replace(CaseInsensitiveStringHashMap.lowercase(key), oldValue, newValue);
    }

    @Override
    public V replace(String key, V value) {
        return super.replace(CaseInsensitiveStringHashMap.lowercase(key), value);
    }

    @Override
    public V computeIfAbsent(String key, @NotNull Function<? super String, ? extends V> mappingFunction) {
        return super.computeIfAbsent(CaseInsensitiveStringHashMap.lowercase(key), mappingFunction);
    }

    @Override
    public V computeIfPresent(String key, @NotNull BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return super.computeIfPresent(CaseInsensitiveStringHashMap.lowercase(key), remappingFunction);
    }

    @Override
    public V compute(String key, @NotNull BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return super.compute(CaseInsensitiveStringHashMap.lowercase(key), remappingFunction);
    }

    @Override
    public V merge(String key, @NotNull V value, @NotNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return super.merge(CaseInsensitiveStringHashMap.lowercase(key), value, remappingFunction);
    }

    private final class CaseInsensitiveKeySet
    extends AbstractSet<String> {
        private final Set<String> internalkeySet;

        CaseInsensitiveKeySet(Set<String> internalkeySet) {
            this.internalkeySet = internalkeySet;
        }

        @Override
        public int size() {
            return CaseInsensitiveStringHashMap.this.size();
        }

        @Override
        public void clear() {
            CaseInsensitiveStringHashMap.this.clear();
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return this.internalkeySet.iterator();
        }

        @Override
        public boolean contains(Object o) {
            return CaseInsensitiveStringHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.internalkeySet.remove(CaseInsensitiveStringHashMap.lowercase(o));
        }

        @Override
        public Spliterator<String> spliterator() {
            return this.internalkeySet.spliterator();
        }

        @Override
        public Object @NotNull [] toArray() {
            return this.internalkeySet.toArray();
        }

        @Override
        public void forEach(Consumer<? super String> action) {
            this.internalkeySet.forEach(action);
        }
    }

    private final class CaseInsensitiveEntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        private final Set<Map.Entry<String, V>> internalEntrySet;

        CaseInsensitiveEntrySet(Set<Map.Entry<String, V>> internalEntrySet) {
            this.internalEntrySet = internalEntrySet;
        }

        @Override
        public int size() {
            return CaseInsensitiveStringHashMap.this.size();
        }

        @Override
        public void clear() {
            CaseInsensitiveStringHashMap.this.clear();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<String, V>> iterator() {
            return this.internalEntrySet.iterator();
        }

        private Object convertEntry(Object o) {
            if (!(o instanceof Map.Entry)) {
                return o;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = CaseInsensitiveStringHashMap.lowercase(e.getKey());
            Object value = e.getValue();
            return new AbstractMap.SimpleEntry(key, value);
        }

        @Override
        public boolean contains(Object o) {
            return this.internalEntrySet.contains(this.convertEntry(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.internalEntrySet.remove(this.convertEntry(o));
        }

        @Override
        public Spliterator<Map.Entry<String, V>> spliterator() {
            return this.internalEntrySet.spliterator();
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<String, V>> action) {
            this.internalEntrySet.forEach(action);
        }
    }
}

