/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime.value;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.runtime.value.ObjectProperty;
import team.unnamed.mocha.runtime.value.ObjectValue;
import team.unnamed.mocha.runtime.value.Value;
import team.unnamed.mocha.util.CaseInsensitiveStringHashMap;

public class MutableObjectBinding
implements ObjectValue {
    private final Map<String, ObjectProperty> properties = new CaseInsensitiveStringHashMap<ObjectProperty>();
    private boolean blocked = false;

    @Override
    @Nullable
    public ObjectProperty getProperty(@NotNull String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean set(@NotNull String name, @Nullable Value value) {
        if (this.blocked) {
            return false;
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, ObjectProperty.property(value, false));
        }
        return true;
    }

    public void setAllFrom(MutableObjectBinding binding) {
        Objects.requireNonNull(binding, "binding");
        if (this.blocked) {
            throw new IllegalStateException("This object binding has been blocked!");
        }
        this.properties.putAll(binding.properties);
    }

    public boolean blocked() {
        return this.blocked;
    }

    public void block() {
        if (this.blocked) {
            throw new IllegalStateException("Already blocked!");
        }
        this.blocked = true;
    }
}

