/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime.binding;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.runtime.binding.BindExternalFunction;
import team.unnamed.mocha.runtime.binding.Binding;
import team.unnamed.mocha.runtime.binding.JavaFieldBinding;
import team.unnamed.mocha.runtime.binding.JavaFunction;
import team.unnamed.mocha.runtime.value.Function;
import team.unnamed.mocha.runtime.value.ObjectProperty;
import team.unnamed.mocha.runtime.value.ObjectValue;
import team.unnamed.mocha.runtime.value.Value;
import team.unnamed.mocha.util.CaseInsensitiveStringHashMap;

@ApiStatus.Internal
public final class JavaObjectBinding
implements ObjectValue {
    private final String[] names;
    private final Map<String, Object> entries = new CaseInsensitiveStringHashMap<Object>();

    JavaObjectBinding(@NotNull @NotNull String @NotNull [] names) {
        this.names = Objects.requireNonNull(names, "names");
    }

    JavaObjectBinding() {
        this.names = new String[0];
    }

    private static <T extends Value> T getBacking(@Nullable Map<String, ObjectProperty> backingProperties, @NotNull String functionName, Class<T> valueType) {
        ObjectProperty property;
        if (backingProperties != null && (property = backingProperties.get(functionName)) != null && valueType.isInstance(property.value())) {
            return (T)((Value)valueType.cast(property.value()));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static <T> JavaObjectBinding of(@NotNull Class<T> clazz, @Nullable T instance, @Nullable ObjectValue backingObject) {
        Binding annotation;
        Binding binding = clazz.getDeclaredAnnotation(Binding.class);
        if (binding == null && instance == null) {
            throw new IllegalArgumentException("Statically bound " + String.valueOf(clazz) + " is not annotated with @Binding");
        }
        JavaObjectBinding object = binding != null ? new JavaObjectBinding(binding.value()) : new JavaObjectBinding();
        Map<String, ObjectProperty> backingProperties = backingObject != null ? backingObject.entries() : null;
        BindExternalFunction.Multiple annotation2 = clazz.getDeclaredAnnotation(BindExternalFunction.Multiple.class);
        if (annotation2 != null) {
            void var9_11;
            BindExternalFunction[] bindExternalFunctionArray = annotation2.value();
            int n = bindExternalFunctionArray.length;
            boolean i = false;
            while (var9_11 < n) {
                String[] method;
                BindExternalFunction externalFunctionBinding = bindExternalFunctionArray[var9_11];
                Class<?> atClass = externalFunctionBinding.at();
                String methodName = externalFunctionBinding.name();
                Object[] parameterTypes = externalFunctionBinding.args();
                try {
                    method = atClass.getDeclaredMethod(methodName, (Class<?>[])parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("No method found with name " + methodName + " and parameter types " + Arrays.toString(parameterTypes) + ". Declared as external binding for " + String.valueOf(clazz), e);
                }
                String alias = externalFunctionBinding.as();
                String functionName = alias.isEmpty() ? methodName : alias;
                Function backing = JavaObjectBinding.getBacking(backingProperties, functionName, Function.class);
                boolean pure = externalFunctionBinding.pure();
                if (backing != null && backing.pure() != pure) {
                    throw new IllegalStateException("Different 'pure' values for interface and Java functions for function " + functionName);
                }
                object.entries.put(functionName, new JavaFunction(instance, (Method)method, backing, pure));
                ++var9_11;
            }
        }
        for (Field field : clazz.getDeclaredFields()) {
            annotation = field.getDeclaredAnnotation(Binding.class);
            if (annotation == null || (instance != null ? Modifier.isStatic(field.getModifiers()) : !Modifier.isStatic(field.getModifiers()))) continue;
            String[] propertyNames = annotation.value();
            if (propertyNames.length < 1) {
                throw new IllegalArgumentException("No property names declared for field " + String.valueOf(field));
            }
            Value backingValue = JavaObjectBinding.getBacking(backingProperties, propertyNames[0], Value.class);
            JavaFieldBinding fieldBinding = new JavaFieldBinding(instance, field, backingValue == null ? null : () -> backingValue);
            for (String propertyName : propertyNames) {
                object.entries.put(propertyName, fieldBinding);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            annotation = accessibleObject.getDeclaredAnnotation(Binding.class);
            if (annotation == null || ((Method)accessibleObject).isSynthetic() || (instance != null ? Modifier.isStatic(((Method)accessibleObject).getModifiers()) : !Modifier.isStatic(((Method)accessibleObject).getModifiers()))) continue;
            String[] functionNames = annotation.value();
            if (functionNames.length < 1) {
                throw new IllegalArgumentException("No function names declared for method " + String.valueOf(accessibleObject));
            }
            Function backing = JavaObjectBinding.getBacking(backingProperties, functionNames[0], Function.class);
            boolean pure = annotation.pure();
            if (backing != null && backing.pure() != pure) {
                throw new IllegalStateException("Different 'pure' values for interface and Java functions for function " + functionNames[0]);
            }
            JavaFunction javaFunction = new JavaFunction(instance, (Method)accessibleObject, backing, pure);
            for (String functionName : functionNames) {
                object.entries.put(functionName, javaFunction);
            }
        }
        return object;
    }

    @NotNull
    public String[] names() {
        return this.names;
    }

    @Nullable
    public JavaFieldBinding getField(@NotNull String name) {
        Object value = this.entries.get(name);
        if (value instanceof JavaFieldBinding) {
            return (JavaFieldBinding)value;
        }
        return null;
    }

    @Override
    @Nullable
    public ObjectProperty getProperty(@NotNull String name) {
        Object value = this.entries.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof JavaFieldBinding) {
            return ObjectProperty.property(((JavaFieldBinding)value).get(), ((JavaFieldBinding)value).constant());
        }
        return ObjectProperty.property((Value)value, true);
    }

    @Override
    public boolean set(@NotNull String name, @Nullable Value value) {
        return true;
    }
}

