/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.parser.ast;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.ExpressionVisitor;

public final class FloatExpression
implements Expression {
    public static final FloatExpression ZERO = new FloatExpression(0.0f);
    public static final FloatExpression ONE = new FloatExpression(1.0f);
    private final float value;

    public FloatExpression(ByteBuf buf) {
        this(buf.readFloat());
    }

    private FloatExpression(float value) {
        this.value = value;
    }

    @NotNull
    public static FloatExpression of(double value) {
        return FloatExpression.of((float)value);
    }

    @NotNull
    public static FloatExpression of(float value) {
        if (value == ONE.value()) {
            return ONE;
        }
        if (value == ZERO.value()) {
            return ZERO;
        }
        return new FloatExpression(value);
    }

    public float value() {
        return this.value;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitFloat(this);
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeFloat(this.value);
    }

    public String toString() {
        if ((float)((long)this.value) == this.value) {
            return String.valueOf((long)this.value);
        }
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatExpression that = (FloatExpression)o;
        return Float.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }
}

