/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.common.utils.server;

import com.sun.net.httpserver.Headers;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.redlance.common.utils.server.LocaleParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ServerUtils");

    public static InetSocketAddress getAddressFromProperties() {
        Properties prop = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(Path.of("server.properties", new String[0]));){
            prop.load(reader);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load server.properties:", (Throwable)e);
        }
        return new InetSocketAddress(prop.getProperty("server-ip", "0.0.0.0"), Integer.parseInt(prop.getProperty("server-port", "25566")));
    }

    public static Map<String, String> getQuery(String uri) {
        return ServerUtils.getQuery(URI.create(uri));
    }

    public static Map<String, String> getQuery(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return Collections.emptyMap();
        }
        return ServerUtils.getQueryRaw(query);
    }

    public static Map<String, String> getQueryRaw(String query) {
        return Stream.of(query.split("&")).map(string -> string.split("=")).filter(strings -> ((String[])strings).length > 1).collect(Collectors.toMap(values -> values[0], values -> values[1]));
    }

    public static Optional<String> getLastSegment(String uri) {
        return ServerUtils.getLastSegment(URI.create(uri));
    }

    public static Optional<String> getLastSegment(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            return Optional.empty();
        }
        return ServerUtils.getLastSegmentRaw(path);
    }

    public static Optional<String> getLastSegmentRaw(String path) {
        String[] segments = path.split("/");
        if (segments.length == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(segments[segments.length - 1]);
    }

    public static Locale findLocale(Headers headers, LocaleParser parser, Supplier<Locale> fallback) {
        return ServerUtils.findLocale(headers::getFirst, parser, fallback);
    }

    public static Locale findLocale(Function<String, String> headers, LocaleParser parser, Supplier<Locale> fallback) {
        String country;
        String userLocale = headers.apply("Accept-Language");
        if (userLocale != null && !userLocale.isBlank()) {
            for (Locale.LanguageRange range : Locale.LanguageRange.parse(userLocale.replace("_", "-"))) {
                Locale locale = parser.parseLocale(range.getRange(), () -> null);
                if (locale == null) continue;
                return locale;
            }
        }
        if ((country = headers.apply("CF-IPCountry")) != null && !country.isBlank()) {
            String countryInLower;
            Object lang = switch (countryInLower = country.toLowerCase(Locale.ROOT)) {
                case "ru" -> "ru_ru";
                case "by" -> "be_by";
                case "kz" -> "kk_kz";
                case "ua" -> "uk_ua";
                case "rs" -> "sr_rs";
                case "bg" -> "bg_bg";
                case "ge" -> "ka_ge";
                case "us", "gb", "au", "nz", "ca", "sg", "za", "ie" -> "en_" + countryInLower;
                case "es", "mx", "ar", "co", "pe", "ve", "cl", "do", "uy", "bo", "cr" -> "es_" + countryInLower;
                case "pt", "br", "ao", "mz" -> "pt_" + countryInLower;
                case "id" -> "id_id";
                case "vn" -> "vi_vn";
                case "jp" -> "ja_jp";
                case "kr" -> "ko_kr";
                case "cn", "tw", "hk" -> "zh_" + countryInLower;
                case "th" -> "th_th";
                case "my" -> "ms_my";
                case "in" -> "hi_in";
                case "pk" -> "ur_pk";
                case "bd" -> "bn_bd";
                case "il" -> "he_il";
                case "ph" -> "fil_ph";
                case "ae", "eg", "tn", "sa", "ma", "dz", "lb" -> "ar_" + countryInLower;
                case "fr", "be", "lu", "mc" -> "fr_" + countryInLower;
                case "ch" -> "de_ch";
                case "de", "at" -> "de_" + countryInLower;
                case "it" -> "it_it";
                case "nl" -> "nl_nl";
                case "pl" -> "pl_pl";
                case "tr" -> "tr_tr";
                case "cz" -> "cs_cz";
                case "hu" -> "hu_hu";
                case "ro" -> "ro_ro";
                case "el" -> "el_gr";
                case "sk" -> "sk_sk";
                case "si" -> "sl_si";
                case "lv" -> "lv_lv";
                case "lt" -> "lt_lt";
                case "se" -> "sv_se";
                case "no" -> "no_no";
                case "dk" -> "da_dk";
                case "fi" -> "fi_fi";
                case "is" -> "is_is";
                case "ir" -> "fa_ir";
                default -> {
                    LOGGER.warn("Country code not explicitly mapped: {}, using English as fallback", (Object)country);
                    yield "en_" + countryInLower;
                }
            };
            return parser.parseLocale((String)lang, fallback);
        }
        return fallback.get();
    }
}

