/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.common.utils;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.redlance.common.utils.LambdaExceptionUtils;
import sun.misc.Unsafe;

public class ReflectUtils {
    public static final Unsafe UNSAFE = ReflectUtils.uncheck(() -> {
        Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
        theUnsafe.setAccessible(true);
        return (Unsafe)theUnsafe.get(null);
    });
    public static final Object INTERNAL_UNSAFE = ReflectUtils.uncheck(() -> {
        Field theUnsafe = Unsafe.class.getDeclaredField("theInternalUnsafe");
        theUnsafe.setAccessible(true);
        return theUnsafe.get(null);
    });
    public static final Method OBJECT_FIELD_OFFSET = ReflectUtils.uncheck(() -> INTERNAL_UNSAFE.getClass().getDeclaredMethod("objectFieldOffset", Field.class));
    public static final MethodHandles.Lookup TRUSTED_LOOKUP = ReflectUtils.uncheck(() -> {
        Field hackfield = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        return (MethodHandles.Lookup)UNSAFE.getObject(UNSAFE.staticFieldBase(hackfield), UNSAFE.staticFieldOffset(hackfield));
    });
    private static final Class<?> UNMODIFIABLE_COLLECTION_CLASS;
    private static final VarHandle COLLECTION_HANDLE;

    public static <R, E extends Exception> R uncheck(LambdaExceptionUtils.Supplier_WithExceptions<R, E> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T> Collection<T> getModifiableCollection(Collection<T> unmodifiable) {
        return COLLECTION_HANDLE.get(unmodifiable);
    }

    public static void setRecordField(Object record, String fieldName, Object newValue) {
        try {
            Field field = record.getClass().getDeclaredField(fieldName);
            long offset = (Long)OBJECT_FIELD_OFFSET.invoke(INTERNAL_UNSAFE, field);
            UNSAFE.putObject(record, offset, newValue);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to mutate record field " + fieldName, e);
        }
    }

    static {
        try {
            TRUSTED_LOOKUP.findVarHandle(AccessibleObject.class, "override", Boolean.TYPE).set(OBJECT_FIELD_OFFSET, true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        UNMODIFIABLE_COLLECTION_CLASS = ReflectUtils.uncheck(() -> Class.forName("java.util.Collections$UnmodifiableCollection"));
        COLLECTION_HANDLE = ReflectUtils.uncheck(() -> TRUSTED_LOOKUP.findVarHandle(UNMODIFIABLE_COLLECTION_CLASS, "c", Collection.class));
    }
}

