/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.txt;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.txt.model.TxtNote;
import net.raphimc.noteblocklib.format.txt.model.TxtSong;
import net.raphimc.noteblocklib.model.Note;

public class TxtIo {
    private static final int BUFFER_SIZE = 0x100000;

    public static TxtSong readSong(InputStream is, String fileName) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8), 0x100000);
        TxtSong song = new TxtSong(fileName);
        Map<Integer, List<TxtNote>> notes = song.getTxtNotes();
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) continue;
            if (line.startsWith("// Name: ")) {
                song.setTitle(line.substring(9));
                continue;
            }
            if (line.startsWith("// Author: ")) {
                song.setAuthor(line.substring(11));
                continue;
            }
            String[] split = line.split(":");
            int tick = Integer.parseInt(split[0]);
            byte key = Byte.parseByte(split[1]);
            byte instrument = Byte.parseByte(split[2]);
            TxtNote note = new TxtNote();
            note.setInstrument(instrument);
            note.setKey(key);
            notes.computeIfAbsent(tick, k -> new ArrayList()).add(note);
        }
        song.getTempoEvents().set(0, 20.0f);
        for (Map.Entry<Integer, List<TxtNote>> entry : notes.entrySet()) {
            for (TxtNote txtNote : entry.getValue()) {
                Note note = new Note();
                note.setInstrument(MinecraftInstrument.fromMcId(txtNote.getInstrument()));
                note.setMcKey(txtNote.getKey());
                song.getNotes().add((int)entry.getKey(), note);
            }
        }
        return song;
    }

    public static void writeSong(TxtSong song, OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os, 0x100000), StandardCharsets.UTF_8);
        if (song.getTitle() != null) {
            writer.write("// Name: " + song.getTitle() + "\n");
        }
        if (song.getAuthor() != null) {
            writer.write("// Author: " + song.getAuthor() + "\n");
        }
        for (Map.Entry<Integer, List<TxtNote>> entry : song.getTxtNotes().entrySet()) {
            for (TxtNote txtNote : entry.getValue()) {
                writer.write(entry.getKey() + ":" + txtNote.getKey() + ":" + txtNote.getInstrument() + "\n");
            }
        }
        writer.flush();
    }
}

