/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.redlance.dima_dencep.mods.emotecraft.geyser.libs.javassist.ClassPool;
import org.redlance.dima_dencep.mods.emotecraft.geyser.libs.javassist.CtClass;
import org.redlance.dima_dencep.mods.emotecraft.geyser.libs.javassist.CtPrimitiveType;
import org.redlance.dima_dencep.mods.emotecraft.geyser.libs.javassist.NotFoundException;
import org.redlance.dima_dencep.mods.emotecraft.geyser.libs.javassist.bytecode.Bytecode;
import team.unnamed.mocha.runtime.TypeCastException;

public class JavassistUtil {
    private static final Set<String> WRAPPER_TYPE_NAMES = new HashSet<String>();

    @NotNull
    public static CtClass getClassUnchecked(@NotNull ClassPool cp, @NotNull Class<?> javaClass) {
        try {
            return cp.get(javaClass.getName());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("CtClass not found for Java class: " + String.valueOf(javaClass), e);
        }
    }

    public static boolean isWrapper(@NotNull CtClass type) {
        Objects.requireNonNull(type, "type");
        return WRAPPER_TYPE_NAMES.contains(type.getName());
    }

    public static boolean isPrimitiveOrWrapper(@NotNull CtClass type) {
        Objects.requireNonNull(type, "type");
        return type.isPrimitive() || JavassistUtil.isWrapper(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addCast(@NotNull Bytecode bytecode, @NotNull CtClass from, @NotNull CtClass to) {
        Objects.requireNonNull(bytecode, "bytecode");
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        if (from.equals(to)) {
            return;
        }
        if (from.equals(CtClass.voidType) || to.equals(CtClass.voidType)) {
            throw new IllegalArgumentException("Cannot cast to or from void");
        }
        if (from.isPrimitive()) {
            if (to.isPrimitive()) {
                if (from.equals(CtClass.intType) || from.equals(CtClass.byteType) || from.equals(CtClass.booleanType) || from.equals(CtClass.shortType) || from.equals(CtClass.charType)) {
                    JavassistUtil.addCastIntTo(bytecode, to);
                    return;
                } else if (from.equals(CtClass.longType)) {
                    JavassistUtil.addCastLongTo(bytecode, to);
                    return;
                } else if (from.equals(CtClass.floatType)) {
                    JavassistUtil.addCastFloatTo(bytecode, to);
                    return;
                } else {
                    if (!from.equals(CtClass.doubleType)) throw new TypeCastException("Cannot cast unknown primitive type: " + from.getName());
                    JavassistUtil.addCastDoubleTo(bytecode, to);
                }
                return;
            } else {
                CtPrimitiveType fromPrimitive = (CtPrimitiveType)from;
                bytecode.addInvokestatic(fromPrimitive.getWrapperName(), "valueOf", "(" + fromPrimitive.getDescriptor() + ")L" + to.getName().replace('.', '/') + ";");
            }
            return;
        } else if (to.isPrimitive()) {
            if (!WRAPPER_TYPE_NAMES.contains(from.getName())) throw new TypeCastException("Cannot cast unknown type: " + from.getName());
            CtPrimitiveType toPrimitive = (CtPrimitiveType)to;
            bytecode.addInvokevirtual(from, toPrimitive.getGetMethodName(), toPrimitive.getGetMethodDescriptor());
            return;
        } else {
            bytecode.addCheckcast(to);
        }
    }

    public static void addCastIntTo(@NotNull Bytecode bytecode, @NotNull CtClass to) {
        Objects.requireNonNull(bytecode, "bytecode");
        Objects.requireNonNull(to, "to");
        if (to.equals(CtClass.intType)) {
            return;
        }
        if (to.equals(CtClass.byteType)) {
            bytecode.addOpcode(145);
        } else if (to.equals(CtClass.booleanType)) {
            bytecode.addOpcode(153);
            bytecode.addIndex(6);
            bytecode.addIconst(1);
            bytecode.addOpcode(167);
            bytecode.addIndex(3);
            bytecode.addIconst(0);
        } else if (to.equals(CtClass.shortType)) {
            bytecode.addOpcode(147);
        } else if (to.equals(CtClass.charType)) {
            bytecode.addOpcode(146);
        } else if (to.equals(CtClass.longType)) {
            bytecode.addOpcode(133);
        } else if (to.equals(CtClass.floatType)) {
            bytecode.addOpcode(134);
        } else if (to.equals(CtClass.doubleType)) {
            bytecode.addOpcode(135);
        } else {
            if (to.equals(CtClass.voidType)) {
                throw new TypeCastException("Cannot cast int to void");
            }
            throw new TypeCastException("Cannot cast int to unknown type: " + to.getName());
        }
    }

    public static void addCastDoubleTo(@NotNull Bytecode bytecode, @NotNull CtClass to) {
        Objects.requireNonNull(bytecode, "bytecode");
        Objects.requireNonNull(to, "to");
        if (to.equals(CtClass.doubleType)) {
            return;
        }
        if (to.equals(CtClass.intType)) {
            bytecode.addOpcode(142);
        } else if (to.equals(CtClass.longType)) {
            bytecode.addOpcode(143);
        } else if (to.equals(CtClass.floatType)) {
            bytecode.addOpcode(144);
        } else {
            if (to.equals(CtClass.voidType)) {
                throw new IllegalArgumentException("Cannot cast double to void");
            }
            bytecode.addOpcode(142);
            try {
                JavassistUtil.addCastIntTo(bytecode, CtClass.intType);
            }
            catch (TypeCastException e) {
                throw new TypeCastException("Cannot cast double to unknown type: " + to.getName());
            }
        }
    }

    public static void addCastLongTo(@NotNull Bytecode bytecode, @NotNull CtClass to) {
        Objects.requireNonNull(bytecode, "bytecode");
        Objects.requireNonNull(to, "to");
        if (to.equals(CtClass.longType)) {
            return;
        }
        if (to.equals(CtClass.intType)) {
            bytecode.addOpcode(136);
        } else if (to.equals(CtClass.doubleType)) {
            bytecode.addOpcode(138);
        } else if (to.equals(CtClass.floatType)) {
            bytecode.addOpcode(137);
        } else {
            if (to.equals(CtClass.voidType)) {
                throw new IllegalArgumentException("Cannot cast long to void");
            }
            bytecode.addOpcode(136);
            try {
                JavassistUtil.addCastIntTo(bytecode, CtClass.intType);
            }
            catch (TypeCastException e) {
                throw new TypeCastException("Cannot cast long to unknown type: " + to.getName());
            }
        }
    }

    public static void addCastFloatTo(@NotNull Bytecode bytecode, @NotNull CtClass to) {
        Objects.requireNonNull(bytecode, "bytecode");
        Objects.requireNonNull(to, "to");
        if (to.equals(CtClass.floatType)) {
            return;
        }
        if (to.equals(CtClass.intType)) {
            bytecode.addOpcode(139);
        } else if (to.equals(CtClass.doubleType)) {
            bytecode.addOpcode(141);
        } else if (to.equals(CtClass.longType)) {
            bytecode.addOpcode(140);
        } else {
            if (to.equals(CtClass.voidType)) {
                throw new IllegalArgumentException("Cannot cast float to void");
            }
            bytecode.addOpcode(139);
            try {
                JavassistUtil.addCastIntTo(bytecode, CtClass.intType);
            }
            catch (TypeCastException e) {
                throw new TypeCastException("Cannot cast float to unknown type: " + to.getName());
            }
        }
    }

    static {
        WRAPPER_TYPE_NAMES.add(Boolean.class.getName());
        WRAPPER_TYPE_NAMES.add(Byte.class.getName());
        WRAPPER_TYPE_NAMES.add(Character.class.getName());
        WRAPPER_TYPE_NAMES.add(Short.class.getName());
        WRAPPER_TYPE_NAMES.add(Integer.class.getName());
        WRAPPER_TYPE_NAMES.add(Long.class.getName());
        WRAPPER_TYPE_NAMES.add(Float.class.getName());
        WRAPPER_TYPE_NAMES.add(Double.class.getName());
    }
}

