/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime.value;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.runtime.value.Value;

public final class NumberValue
implements Value {
    private static final NumberValue ONE = new NumberValue(1.0f);
    private static final NumberValue ZERO = new NumberValue(0.0f);
    private final float value;

    private NumberValue(float value) {
        this.value = NumberValue.normalize(value);
    }

    @NotNull
    public static NumberValue of(double value) {
        return NumberValue.of((float)value);
    }

    @NotNull
    public static NumberValue of(float value) {
        if (value == ONE.value()) {
            return ONE;
        }
        if (value == ZERO.value()) {
            return ZERO;
        }
        return new NumberValue(value);
    }

    @NotNull
    public static NumberValue one() {
        return ONE;
    }

    @NotNull
    public static NumberValue zero() {
        return ZERO;
    }

    public static double normalize(double value) {
        return Double.isNaN(value) || Double.isInfinite(value) ? 0.0 : value;
    }

    public static float normalize(float value) {
        return Float.isNaN(value) || Float.isInfinite(value) ? 0.0f : value;
    }

    public float value() {
        return this.value;
    }

    @NotNull
    public String toString() {
        return "NumberValue(" + this.value + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberValue that = (NumberValue)o;
        return Float.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }
}

