/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime.binding;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.runtime.ExecutionContext;
import team.unnamed.mocha.runtime.JavaTypes;
import team.unnamed.mocha.runtime.binding.Entity;
import team.unnamed.mocha.runtime.binding.Lazy;
import team.unnamed.mocha.runtime.value.ArrayValue;
import team.unnamed.mocha.runtime.value.Function;
import team.unnamed.mocha.runtime.value.JavaValue;
import team.unnamed.mocha.runtime.value.NumberValue;
import team.unnamed.mocha.runtime.value.StringValue;
import team.unnamed.mocha.runtime.value.Value;

final class ReflectiveFunction<T>
implements Function<T> {
    private final Method method;
    private final MethodHandle mh;

    ReflectiveFunction(@Nullable Object object, @NotNull Method method) {
        this.method = Objects.requireNonNull(method, "method");
        try {
            MethodHandle handle = MethodHandles.lookup().unreflect(method);
            if (object != null) {
                handle = handle.bindTo(object);
            }
            this.mh = handle;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    static Value of(@Nullable Object any) {
        if (any instanceof Value) {
            return (Value)any;
        }
        if (any instanceof Number) {
            return NumberValue.of(((Number)any).floatValue());
        }
        if (any instanceof String) {
            return StringValue.of((String)any);
        }
        if (any instanceof Boolean) {
            return (Boolean)any != false ? NumberValue.one() : NumberValue.zero();
        }
        if (any != null && any.getClass().isArray()) {
            int length = Array.getLength(any);
            Value[] values = new Value[length];
            for (int i = 0; i < length; ++i) {
                values[i] = ReflectiveFunction.of(Array.get(any, i));
            }
            return ArrayValue.of(values);
        }
        if (any != null) {
            return new JavaValue(any);
        }
        return Value.nil();
    }

    @Override
    @NotNull
    public Value evaluate(@NotNull ExecutionContext<T> context, @NotNull Function.Arguments arguments) {
        Parameter[] parameters = this.method.getParameters();
        Type[] genericParameterTypes = this.method.getGenericParameterTypes();
        Object[] values = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Value value;
            Parameter parameter = parameters[i];
            Class parameterType = parameter.getType();
            if (i == parameters.length - 1 && this.method.isVarArgs()) {
                Class<?> componentType = parameterType.getComponentType();
                ArrayList<Value> varArgsValues = new ArrayList<Value>();
                while ((argument = arguments.next()).expression() != null) {
                    Value object = argument.eval();
                    if (componentType.isInstance(object)) {
                        varArgsValues.add(object);
                        continue;
                    }
                    varArgsValues.add(null);
                }
                value = ArrayValue.of((Value[])varArgsValues.toArray(size -> (Value[])Array.newInstance(componentType, size)));
            } else if (parameterType == Lazy.class) {
                Type genericParameterType = genericParameterTypes[i];
                if (!(genericParameterType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Lazy<T> parameter must be a parameterized type.");
                }
                parameterType = (Class)((ParameterizedType)genericParameterType).getActualTypeArguments()[0];
                if (parameterType == ExecutionContext.class) {
                    value = new JavaValue(() -> context);
                } else {
                    Class argumentType = parameterType;
                    argument = arguments.next();
                    value = new JavaValue(() -> {
                        Value object = argument.eval();
                        if (argumentType.isInstance(object)) {
                            return object;
                        }
                        return null;
                    });
                }
            } else if (parameterType == ExecutionContext.class) {
                value = new JavaValue(context);
            } else if (parameter.isAnnotationPresent(Entity.class)) {
                value = new JavaValue(context.entity());
            } else {
                Function.Argument argument = arguments.next();
                value = argument.eval();
            }
            values[i] = value == null ? JavaTypes.getNullValueForType(parameterType) : (parameter.isAnnotationPresent(Entity.class) ? ((JavaValue)value).value() : JavaTypes.convert(value, parameterType));
        }
        try {
            return ReflectiveFunction.of(this.mh.invokeWithArguments(values));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

