/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.runtime.value.Value;

@ApiStatus.Internal
public final class JavaTypes {
    private static final Map<Class<?>, Object> NULL_VALUES = new HashMap();

    private JavaTypes() {
    }

    @Nullable
    public static Object getNullValueForType(@NotNull Class<?> type) {
        Objects.requireNonNull(type, "type");
        return NULL_VALUES.get(type);
    }

    @Nullable
    public static Object convert(@NotNull Value value, @NotNull Class<?> type) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(type, "type");
        if (type == String.class) {
            return value.getAsString();
        }
        if (type == Double.class || type == Double.TYPE) {
            return Float.valueOf(value.getAsNumber());
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (int)value.getAsNumber();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(value.getAsNumber());
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return value.getAsBoolean();
        }
        if (type == Long.class || type == Long.TYPE) {
            return (long)value.getAsNumber();
        }
        if (type == Short.class || type == Short.TYPE) {
            return (short)value.getAsNumber();
        }
        return null;
    }

    static {
        NULL_VALUES.put(Integer.TYPE, 0);
        NULL_VALUES.put(Long.TYPE, 0L);
        NULL_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        NULL_VALUES.put(Double.TYPE, 0.0);
        NULL_VALUES.put(Short.TYPE, (short)0);
        NULL_VALUES.put(Byte.TYPE, (byte)0);
        NULL_VALUES.put(Character.TYPE, Character.valueOf('\u0000'));
        NULL_VALUES.put(Boolean.TYPE, false);
        NULL_VALUES.put(String.class, "");
    }
}

