/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.parser.ast;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.ExpressionVisitor;
import team.unnamed.mocha.util.ExprBytesUtils;
import team.unnamed.mocha.util.network.ProtocolUtils;

public final class UnaryExpression
implements Expression {
    private final Op op;
    private Expression expression;

    public UnaryExpression(ByteBuf buf) {
        this(ProtocolUtils.readEnum(Op.class, buf), ExprBytesUtils.readExpression(buf));
    }

    public UnaryExpression(@NotNull Op op, @NotNull Expression expression) {
        this.op = Objects.requireNonNull(op, "op");
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    @NotNull
    public Op op() {
        return this.op;
    }

    @NotNull
    public Expression expression() {
        return this.expression;
    }

    public void expression(@NotNull Expression expression) {
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitUnary(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ProtocolUtils.writeEnum(this.op(), buf);
        ExprBytesUtils.writeExpression(this.expression, buf);
    }

    public String toString() {
        return String.format("%s(%s)", new Object[]{this.op, this.expression});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnaryExpression that = (UnaryExpression)o;
        if (this.op != that.op) {
            return false;
        }
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        int result = this.op.hashCode();
        result = 31 * result + this.expression.hashCode();
        return result;
    }

    public static enum Op {
        LOGICAL_NEGATION("!"),
        ARITHMETICAL_NEGATION("-"),
        RETURN("return ");

        private final String string;

        private Op(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

