/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.parser.ast;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.ExpressionVisitor;
import team.unnamed.mocha.util.ExprBytesUtils;
import team.unnamed.mocha.util.ExpressionListUtils;

public final class ExecutionScopeExpression
implements Expression {
    private final List<Expression> expressions;

    public ExecutionScopeExpression(ByteBuf buf) {
        this(ExprBytesUtils.readExpressions(buf));
    }

    public ExecutionScopeExpression(@NotNull List<Expression> expressions) {
        this.expressions = Objects.requireNonNull(expressions, "expressions");
    }

    @NotNull
    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitExecutionScope(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ExprBytesUtils.writeExpressions(this.expressions(), buf);
    }

    public String toString() {
        return String.format("{%s}", ExpressionListUtils.toString(this.expressions));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionScopeExpression that = (ExecutionScopeExpression)o;
        return this.expressions.equals(that.expressions);
    }

    public int hashCode() {
        return Objects.hash(this.expressions);
    }
}

