/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.parser;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.mocha.lexer.Cursor;
import team.unnamed.mocha.lexer.MolangLexer;
import team.unnamed.mocha.parser.MolangParserImpl;
import team.unnamed.mocha.parser.ast.Expression;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MolangParser
extends Closeable {
    @NotNull
    public MolangLexer lexer();

    @NotNull
    default public Cursor cursor() {
        return this.lexer().cursor();
    }

    @Nullable
    public Expression current();

    @Nullable
    public Expression next() throws IOException;

    @NotNull
    default public List<Expression> parseAll() throws IOException {
        Expression expr;
        ArrayList<Expression> tokens = new ArrayList<Expression>();
        while ((expr = this.next()) != null) {
            tokens.add(expr);
        }
        return tokens;
    }

    @Override
    public void close() throws IOException;

    @NotNull
    public static MolangParser parser(@NotNull MolangLexer lexer) throws IOException {
        return new MolangParserImpl(lexer);
    }

    @NotNull
    public static MolangParser parser(@NotNull Reader reader) throws IOException {
        return MolangParser.parser(MolangLexer.lexer(reader));
    }

    @NotNull
    public static MolangParser parser(@NotNull String string) throws IOException {
        return MolangParser.parser(MolangLexer.lexer(string));
    }

    @NotNull
    public static List<Expression> parseAll(@NotNull Reader reader) throws IOException {
        try (MolangParser parser = MolangParser.parser(reader);){
            List<Expression> list = parser.parseAll();
            return list;
        }
    }

    @NotNull
    public static List<Expression> parseAll(@NotNull String string) throws IOException {
        try (MolangParser parser = MolangParser.parser(string);){
            List<Expression> list = parser.parseAll();
            return list;
        }
    }
}

