/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.redlance.dima_dencep.mods.emotecraft.geyser.libs.javassist.ClassPool;
import team.unnamed.mocha.MochaEngineImpl;
import team.unnamed.mocha.parser.ParseException;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.runtime.MochaFunction;
import team.unnamed.mocha.runtime.Scope;
import team.unnamed.mocha.runtime.binding.JavaObjectBinding;
import team.unnamed.mocha.runtime.compiled.MochaCompiledFunction;
import team.unnamed.mocha.runtime.standard.MochaMath;
import team.unnamed.mocha.runtime.value.MutableObjectBinding;

public interface MochaEngine<T> {
    public static <T> MochaEngine<T> create(T entity) {
        return new MochaEngineImpl<T>(entity, b -> {});
    }

    public static <T> MochaEngine<T> create(T entity, Consumer<Scope.Builder> scopeBuilder) {
        return new MochaEngineImpl<T>(entity, scopeBuilder);
    }

    public static MochaEngine<?> create() {
        return new MochaEngineImpl<Object>(null, b -> {});
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <T> MochaEngine<T> createStandard(T entity) {
        return MochaEngine.create(entity, builder -> {
            builder.set("math", JavaObjectBinding.of(MochaMath.class, null, new MochaMath()));
            MutableObjectBinding variableBinding = new MutableObjectBinding();
            builder.set("variable", variableBinding);
            builder.set("v", variableBinding);
        });
    }

    @Contract(value="-> new")
    @NotNull
    public static MochaEngine<?> createStandard() {
        return MochaEngine.createStandard(null);
    }

    @NotNull
    public List<Expression> parse(@NotNull Reader var1) throws IOException;

    @NotNull
    default public List<Expression> parse(@NotNull String string) throws ParseException {
        StringReader reader = new StringReader(string);
        try {
            List<Expression> list = this.parse(reader);
            reader.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException e) {
                throw e;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error occurred reading the source code: '" + string + "'", e);
            }
        }
    }

    public float eval(@NotNull List<Expression> var1, @Nullable Consumer<Scope> var2);

    default public float eval(@NotNull List<Expression> expressions) {
        return this.eval(expressions, null);
    }

    public float eval(@NotNull Reader var1, @Nullable Consumer<Scope> var2);

    default public float eval(@NotNull Reader source) {
        return this.eval(source, null);
    }

    default public float eval(@NotNull String source, @Nullable Consumer<Scope> scopeConsumer) {
        Objects.requireNonNull(source, "script");
        try (StringReader reader = new StringReader(source);){
            float f = this.eval(reader, scopeConsumer);
            return f;
        }
    }

    default public float eval(@NotNull String source) {
        return this.eval(source, null);
    }

    @NotNull
    public MochaFunction prepareEval(@NotNull Reader var1, @Nullable Consumer<Scope> var2);

    @NotNull
    default public MochaFunction prepareEval(@NotNull Reader reader) {
        return this.prepareEval(reader, null);
    }

    @NotNull
    default public MochaFunction prepareEval(@NotNull String string, @Nullable Consumer<Scope> scopeConsumer) {
        try (StringReader reader = new StringReader(string);){
            MochaFunction mochaFunction = this.prepareEval(reader, scopeConsumer);
            return mochaFunction;
        }
    }

    @NotNull
    default public MochaFunction prepareEval(@NotNull String string) {
        return this.prepareEval(string, null);
    }

    @NotNull
    public <F extends MochaCompiledFunction> F compile(@NotNull Reader var1, @NotNull Class<F> var2);

    @NotNull
    public <F extends MochaCompiledFunction> F compile(@NotNull List<Expression> var1, @NotNull Class<F> var2);

    @NotNull
    default public <F extends MochaCompiledFunction> F compile(@NotNull String code, @NotNull Class<F> interfaceType) {
        Objects.requireNonNull(code, "code");
        try (StringReader reader = new StringReader(code);){
            F f = this.compile(reader, interfaceType);
            return f;
        }
    }

    @NotNull
    default public MochaFunction compile(@NotNull Reader reader) {
        return this.compile(reader, MochaFunction.class);
    }

    @NotNull
    default public MochaFunction compile(@NotNull List<Expression> expressions) {
        return this.compile(expressions, MochaFunction.class);
    }

    @NotNull
    default public MochaFunction compile(@NotNull String code) {
        Objects.requireNonNull(code, "code");
        try (StringReader reader = new StringReader(code);){
            MochaFunction mochaFunction = this.compile(reader);
            return mochaFunction;
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public ClassPool classPool();

    public void bind(@NotNull Class<?> var1);

    public <B> void bindInstance(@NotNull Class<? super B> var1, @NotNull B var2, @NotNull String var3, String ... var4);

    @Contract(value="_ -> this")
    @NotNull
    public MochaEngine<T> warnOnReflectiveFunctionUsage(boolean var1);

    @Contract(value="_ -> this")
    @NotNull
    public MochaEngine<T> handleParseExceptions(@Nullable Consumer<@NotNull ParseException> var1);

    @Contract(value="_ -> this")
    @NotNull
    public MochaEngine<T> postCompile(@Nullable Consumer<byte @NotNull []> var1);

    @NotNull
    public Scope scope();
}

