/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs;

import java.util.Iterator;
import java.util.List;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Song;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.Song;

public class NbsConverter {
    public static NbsSong createSong(Song song) {
        NbsSong newSong = new NbsSong();
        newSong.copyGeneralData(song);
        newSong.setLength((short)song.getNotes().getLengthInTicks());
        newSong.setTempo((short)Math.round(song.getTempoEvents().get(0) * 100.0f));
        for (int tick : song.getNotes().getTicks()) {
            List<Note> notes = song.getNotes().get(tick);
            for (int i = 0; i < notes.size(); ++i) {
                Note note = notes.get(i);
                NbsNote nbsNote = new NbsNote();
                if (note.getInstrument() instanceof MinecraftInstrument) {
                    nbsNote.setInstrument(((MinecraftInstrument)note.getInstrument()).nbsId());
                } else {
                    if (!(note.getInstrument() instanceof NbsCustomInstrument)) continue;
                    NbsCustomInstrument customInstrument = (NbsCustomInstrument)note.getInstrument();
                    if (!newSong.getCustomInstruments().contains(customInstrument)) {
                        newSong.getCustomInstruments().add(customInstrument);
                    }
                    nbsNote.setInstrument((short)(newSong.getVanillaInstrumentCount() + newSong.getCustomInstruments().indexOf(customInstrument)));
                }
                nbsNote.setKey((byte)Math.max(0, Math.min(87, note.getNbsKey())));
                nbsNote.setVelocity((byte)Math.round(note.getVolume() * 100.0f));
                nbsNote.setPanning((short)(Math.round(note.getPanning() * 100.0f) + 100));
                nbsNote.setPitch((short)Math.round(note.getFractionalKeyPart() * 100.0f));
                NbsLayer nbsLayer = newSong.getLayers().computeIfAbsent(i, k -> new NbsLayer());
                nbsLayer.getNotes().put(tick, nbsNote);
            }
        }
        newSong.getCustomInstruments().replaceAll(NbsCustomInstrument::copy);
        if (song.getTempoEvents().getTicks().size() > 1) {
            NbsCustomInstrument tempoChangerInstrument = new NbsCustomInstrument();
            tempoChangerInstrument.setName("Tempo Changer");
            short instrumentId = (short)(newSong.getVanillaInstrumentCount() + newSong.getCustomInstruments().size());
            newSong.getCustomInstruments().add(tempoChangerInstrument);
            NbsLayer tempoChangerLayer = new NbsLayer();
            tempoChangerLayer.setName("Tempo Changer");
            tempoChangerLayer.setVolume((byte)0);
            newSong.getLayers().put(newSong.getLayers().size(), tempoChangerLayer);
            Iterator iterator = song.getTempoEvents().getTicks().iterator();
            while (iterator.hasNext()) {
                int tempoEventTick = (Integer)iterator.next();
                float tps = song.getTempoEvents().get(tempoEventTick);
                NbsNote tempoChangerNote = new NbsNote();
                tempoChangerNote.setInstrument(instrumentId);
                tempoChangerNote.setKey((byte)45);
                tempoChangerNote.setPitch((short)Math.round(tps * 15.0f));
                tempoChangerLayer.getNotes().put(tempoEventTick, tempoChangerNote);
            }
        }
        newSong.setLayerCount((short)newSong.getLayers().size());
        newSong.setSourceFileName(song.getFileName());
        if (song instanceof NbsSong) {
            NbsSong nbsSong = (NbsSong)song;
            newSong.setAutoSave(nbsSong.isAutoSave());
            newSong.setAutoSaveInterval(nbsSong.getAutoSaveInterval());
            newSong.setTimeSignature(nbsSong.getTimeSignature());
            newSong.setMinutesSpent(nbsSong.getMinutesSpent());
            newSong.setLeftClicks(nbsSong.getLeftClicks());
            newSong.setRightClicks(nbsSong.getRightClicks());
            newSong.setNoteBlocksAdded(nbsSong.getNoteBlocksAdded());
            newSong.setNoteBlocksRemoved(nbsSong.getNoteBlocksRemoved());
            newSong.setSourceFileName(nbsSong.getSourceFileName());
            newSong.setLoop(nbsSong.isLoop());
            newSong.setMaxLoopCount(nbsSong.getMaxLoopCount());
            newSong.setLoopStartTick(nbsSong.getLoopStartTick());
        } else if (song instanceof McSp2Song) {
            McSp2Song mcSp2Song = (McSp2Song)song;
            newSong.setAutoSave(mcSp2Song.getAutoSaveInterval() != 0);
            newSong.setAutoSaveInterval((byte)mcSp2Song.getAutoSaveInterval());
            newSong.setMinutesSpent(mcSp2Song.getMinutesSpent());
            newSong.setLeftClicks(mcSp2Song.getLeftClicks());
            newSong.setRightClicks(mcSp2Song.getRightClicks());
            newSong.setNoteBlocksAdded(mcSp2Song.getNoteBlocksAdded());
            newSong.setNoteBlocksRemoved(mcSp2Song.getNoteBlocksRemoved());
        }
        return newSong;
    }
}

