/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.server.config.ConfigSerializer;
import io.github.kosmx.emotes.server.services.InstanceService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;

public class Serializer<T extends SerializableConfig> {
    public static Serializer<?> INSTANCE;
    protected final ConfigSerializer<T> configSerializer;
    protected final Class<T> configClass;
    private final Consumer<GsonBuilder> consumer;
    protected final Gson serializer;
    private T config;

    public Serializer(ConfigSerializer<T> configSuppler, Class<T> configClass) {
        this(configSuppler, configClass, GsonBuilder::setPrettyPrinting);
    }

    protected Serializer(ConfigSerializer<T> configSuppler, Class<T> configClass, Consumer<GsonBuilder> consumer) {
        this.configSerializer = configSuppler;
        this.configClass = configClass;
        this.consumer = consumer;
        this.serializer = this.initializeSerializer(new GsonBuilder());
    }

    protected Gson initializeSerializer(GsonBuilder builder) {
        builder.registerTypeAdapter(this.configClass, this.configSerializer);
        if (this.consumer != null) {
            this.consumer.accept(builder);
        }
        return builder.disableHtmlEscaping().create();
    }

    public boolean saveConfig() {
        return this.saveConfig(this.config);
    }

    public boolean saveConfig(T config) {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newBufferedWriter(InstanceService.INSTANCE.getConfigPath(), new OpenOption[0]);
            try {
                this.serializer.toJson(config, this.configClass, (Appendable)writer);
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CommonData.LOGGER.error("Failed to save config!", (Throwable)e);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }

    public T readConfig() {
        if (this.config == null) {
            CommonData.LOGGER.debug("Loading config...");
            this.config = this.readConfig(InstanceService.INSTANCE.getConfigPath());
        }
        return this.config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T readConfig(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            T config = this.readConfig((BufferedReader)null);
            this.saveConfig(config);
            return config;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            T t = this.readConfig(reader);
            return t;
        }
        catch (JsonParseException | IOException e) {
            CommonData.LOGGER.warn("Failed to read config!", e);
            CommonData.LOGGER.warn("If you want to regenerate the config, delete the old files!");
            return this.readConfig((BufferedReader)null);
        }
    }

    protected T readConfig(BufferedReader reader) throws JsonSyntaxException, JsonIOException {
        if (reader != null) {
            SerializableConfig config = (SerializableConfig)this.serializer.fromJson((Reader)reader, this.configClass);
            if (config == null) {
                throw new JsonParseException("Json is empty");
            }
            return (T)config;
        }
        return (T)((SerializableConfig)this.configSerializer.configSuppler.get());
    }

    public static SerializableConfig getConfig() {
        return INSTANCE.readConfig();
    }
}

