/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.nbsplayer;

import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.enums.State;
import io.github.kosmx.emotes.common.CommonData;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.Song;
import net.raphimc.noteblocklib.player.SongPlayer;
import org.jetbrains.annotations.Nullable;
import org.redlance.dima_dencep.mods.emotecraft.geyser.libs.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_Thread;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class NbsPlayer
extends SongPlayer {
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(5, J_L_Thread.ofVirtual().name("Emotecraft-NBSplayer-", 0L).factory());
    @Nullable
    protected final AnimationController controller;
    protected int loopCount = 0;
    private boolean firstSongPlayed;

    public NbsPlayer(Song song, @Nullable AnimationController controller) {
        super(song);
        this.controller = controller;
        this.setCustomScheduler(EXECUTOR);
    }

    @Override
    protected void playNotes(List<Note> notes) {
        this.firstSongPlayed = true;
        for (Note note : notes) {
            this.playNote(note);
        }
    }

    @Override
    protected boolean shouldTick() {
        if (this.controller == null) {
            return true;
        }
        if (!this.controller.isActive()) {
            this.stop();
            return false;
        }
        return this.controller.getAnimationState() == State.RUNNING;
    }

    protected abstract void playNote(Note var1);

    @Override
    protected void onSongFinished() {
        NbsSong nbsSong;
        super.onSongFinished();
        Song song = this.getSong();
        if (song instanceof NbsSong && (nbsSong = (NbsSong)song).isLoop() && (this.loopCount < nbsSong.getMaxLoopCount() || nbsSong.getMaxLoopCount() == 0)) {
            ++this.loopCount;
            this.start((int)(1000.0f / this.getCurrentTicksPerSecond()), nbsSong.getLoopStartTick());
        }
    }

    public boolean isFirstSongPlayed() {
        return this.firstSongPlayed;
    }

    @Override
    protected void onTickException(Throwable e) {
        CommonData.LOGGER.warn("An error occurred while playing nbs!", e);
        this.stop();
    }
}

