/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimcore.easing;

import com.zigythebird.playeranimcore.animation.keyframe.AnimationPoint;
import com.zigythebird.playeranimcore.easing.CubicBezierCurve;
import com.zigythebird.playeranimcore.easing.EasingType;
import com.zigythebird.playeranimcore.easing.EasingTypeTransformer;
import com.zigythebird.playeranimcore.math.ModVector2d;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.redlance.dima_dencep.mods.emotecraft.geyser.libs.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import team.unnamed.mocha.MochaEngine;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.runtime.standard.MochaMath;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class BezierEasing
implements EasingTypeTransformer {
    BezierEasing() {
    }

    @Override
    public Float2FloatFunction buildTransformer(@Nullable Float value) {
        return EasingType.easeIn(EasingType::linear);
    }

    abstract boolean isEasingBefore();

    @Override
    public float apply(MochaEngine<?> env, AnimationPoint animationPoint, @Nullable Float easingValue, float lerpValue) {
        float leftTime;
        List<List<Expression>> easingArgs = animationPoint.easingArgs();
        if (easingArgs.isEmpty()) {
            return MochaMath.lerp(animationPoint.animationStartValue(), animationPoint.animationEndValue(), ((Float)this.buildTransformer(easingValue).apply((Object)Float.valueOf(lerpValue))).floatValue());
        }
        float rightValue = this.isEasingBefore() ? 0.0f : env.eval(J_U_List.getFirst(easingArgs));
        float rightTime = this.isEasingBefore() ? 0.1f : env.eval(easingArgs.get(1));
        float leftValue = this.isEasingBefore() ? env.eval(J_U_List.getFirst(easingArgs)) : 0.0f;
        float f = leftTime = this.isEasingBefore() ? env.eval(easingArgs.get(1)) : -0.1f;
        if (easingArgs.size() > 3) {
            rightValue = env.eval(easingArgs.get(2));
            rightTime = env.eval(easingArgs.get(3));
        }
        leftValue = (float)Math.toRadians(leftValue);
        rightValue = (float)Math.toRadians(rightValue);
        float gapTime = animationPoint.transitionLength() / 20.0f;
        float time_handle_before = BezierEasing.jvmdg$inlined$clamp(rightTime, 0.0f, gapTime);
        float time_handle_after = BezierEasing.jvmdg$inlined$clamp(leftTime, -gapTime, 0.0f);
        CubicBezierCurve curve = new CubicBezierCurve(new ModVector2d(0.0f, animationPoint.animationStartValue()), new ModVector2d(time_handle_before, animationPoint.animationStartValue() + rightValue), new ModVector2d(time_handle_after + gapTime, animationPoint.animationEndValue() + leftValue), new ModVector2d(gapTime, animationPoint.animationEndValue()));
        float time = gapTime * lerpValue;
        List<ModVector2d> points = curve.getPoints(200);
        ModVector2d closest = new ModVector2d();
        float closest_diff = Float.POSITIVE_INFINITY;
        for (ModVector2d point : points) {
            float diff = Math.abs(point.x - time);
            if (!(diff < closest_diff)) continue;
            closest_diff = diff;
            closest.set(point);
        }
        ModVector2d second_closest = new ModVector2d();
        closest_diff = Float.POSITIVE_INFINITY;
        for (ModVector2d point : points) {
            float diff;
            if (point == closest || !((diff = Math.abs(point.x - time)) < closest_diff)) continue;
            closest_diff = diff;
            second_closest.set(closest);
            second_closest.set(point);
        }
        return MochaMath.lerp(closest.y, second_closest.y, BezierEasing.jvmdg$inlined$clamp(MochaMath.lerp(closest.x, second_closest.x, time), 0.0f, 1.0f));
    }

    @Stub(ref=@Ref(value="java/lang/Math"))
    private static /* synthetic */ float jvmdg$inlined$clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }
}

