/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.utils;

import com.zigythebird.playeranimcore.animation.Animation;
import java.net.URI;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.geysermc.cumulus.component.ButtonComponent;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.EmotecraftLocale;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FormUtils {
    private static final Component AUTHOR = Component.translatable((String)"emotecraft.emote.author");

    public static ButtonComponent createButtonComponent(Animation animation, String locale) {
        return ButtonComponent.of((String)FormUtils.formatAnimationName(animation, locale), (FormImage)FormImage.of((FormImage.Type)FormImage.Type.URL, (String)String.format("https://bot.redlance.org/api/emotes/icon/%s.png#%s", animation.boneAnimations().hashCode(), animation.uuid())));
    }

    private static String formatAnimationName(Animation animation, String locale) {
        Object object = animation.data().getRaw("name");
        if (object instanceof String) {
            String rawName = (String)object;
            String name = EmotecraftLocale.getLocaleString(MessageTranslator.convertMessageLenient((String)rawName, (String)locale), locale);
            Object object2 = animation.data().getRaw("author");
            if (object2 instanceof String) {
                String rawAuthor = (String)object2;
                String author = EmotecraftLocale.getLocaleString(MessageTranslator.convertMessage((Component)AUTHOR, (String)locale), locale);
                name = String.format("%s\n(%s%s)", name, author, MessageTranslator.convertMessageLenient((String)rawAuthor, (String)locale));
            }
            return name;
        }
        return String.format("INVALID: %s", animation.uuid());
    }

    @Nullable
    public static UUID extractAnimationFromButton(@NotNull ButtonComponent button) {
        FormImage image = button.image();
        if (image == null) {
            return null;
        }
        return FormUtils.extractAnimationFromImage(image);
    }

    @Nullable
    public static UUID extractAnimationFromImage(@NotNull FormImage button) {
        return switch (button.type()) {
            default -> throw new MatchException(null, null);
            case FormImage.Type.URL -> UUID.fromString(URI.create(button.data()).getFragment());
            case FormImage.Type.PATH -> null;
        };
    }
}

