/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.kosmx.emotes.common.CommonData;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.JsonUtils;

public class EmotecraftLocale {
    private static final Map<String, Map<String, String>> LOCALE_MAPPINGS = new HashMap<String, Map<String, String>>();

    public static void loadLocale(String locale) {
        if (LOCALE_MAPPINGS.containsKey(locale)) {
            return;
        }
        try (InputStream localeStream = EmotecraftLocale.class.getResourceAsStream("/assets/emotecraft/lang/" + locale + ".json");){
            JsonObject localeObj = JsonUtils.fromJson((InputStream)Objects.requireNonNull(localeStream));
            HashMap<String, String> langMap = new HashMap<String, String>();
            for (Map.Entry entry : localeObj.entrySet()) {
                langMap.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            LOCALE_MAPPINGS.put(locale, langMap);
        }
        catch (FileNotFoundException e) {
            throw new AssertionError((Object)GeyserLocale.getLocaleStringLog((String)"geyser.locale.fail.file", (Object[])new Object[]{locale, e.getMessage()}));
        }
        catch (Exception e) {
            throw new AssertionError(GeyserLocale.getLocaleStringLog((String)"geyser.locale.fail.json", (Object[])new Object[]{locale}), e);
        }
    }

    public static String getLocaleString(String messageText, String locale) {
        EmotecraftLocale.loadLocale(locale.toLowerCase(Locale.ROOT));
        Map<String, String> localeStrings = LOCALE_MAPPINGS.get(locale.toLowerCase(Locale.ROOT));
        if (localeStrings == null && (localeStrings = LOCALE_MAPPINGS.get(GeyserLocale.getDefaultLocale().toLowerCase(Locale.ROOT))) == null) {
            CommonData.LOGGER.warn("MISSING DEFAULT LOCALE: {}", (Object)GeyserLocale.getDefaultLocale());
            return messageText;
        }
        return localeStrings.getOrDefault(messageText, messageText);
    }

    static {
        EmotecraftLocale.loadLocale("en_us");
        EmotecraftLocale.loadLocale(GeyserLocale.getDefaultLocale().toLowerCase(Locale.ROOT));
    }
}

