/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.utils;

import io.github.kosmx.emotes.common.CommonData;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.key.Key;

public class DinnerboneProtocolUtils {
    public static Set<Key> readChannels(ByteBuf buf) {
        StringBuilder builder = new StringBuilder();
        HashSet<Key> channels = new HashSet<Key>();
        while (buf.isReadable()) {
            char c = (char)buf.readByte();
            if (c == '\u0000') {
                DinnerboneProtocolUtils.parseAndAddChannel(builder, channels);
                continue;
            }
            builder.append(c);
        }
        DinnerboneProtocolUtils.parseAndAddChannel(builder, channels);
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseAndAddChannel(StringBuilder builder, Set<Key> channels) {
        if (builder.isEmpty()) {
            return;
        }
        String channel = builder.toString();
        try {
            channels.add(Key.key((String)channel));
        }
        catch (Exception e) {
            CommonData.LOGGER.error("Invalid channel: '{}'!", (Object)channel, (Object)e);
        }
        finally {
            builder.setLength(0);
        }
    }

    public static void writeChannels(ByteBuf buf, Set<Key> channels) {
        for (Key channel : channels) {
            for (char c : channel.asString().toCharArray()) {
                buf.writeByte((int)c);
            }
            buf.writeByte(0);
        }
    }
}

