/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonObject;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import com.zigythebird.playeranimcore.util.JsonUtil;
import io.github.kosmx.emotes.common.CommonData;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.redlance.dima_dencep.mods.emotecraft.geyser.EmotecraftExt;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.resourcepack.EmoteResourcePack;

public class BedrockEmoteLoader
extends CacheLoader<String, CompletableFuture<Animation>> {
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
    private static final LoadingCache<String, CompletableFuture<Animation>> BEDROCK_KEYFRAMES = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(5L, TimeUnit.HOURS).build((CacheLoader)new BedrockEmoteLoader());

    @NotNull
    public CompletableFuture<Animation> load(@NotNull String emoteId) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.redlance.org/bugrock/v1/marketplace/get-emote-by-uuid")).header("user-agent", EmotecraftExt.getInstance().description().toString()).POST(HttpRequest.BodyPublishers.ofString(emoteId)).build();
        CommonData.LOGGER.debug("Sending request: {}", (Object)request);
        return ((CompletableFuture)HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).thenApply(this::parseAnimation)).exceptionally(throwable -> {
            BEDROCK_KEYFRAMES.invalidate((Object)emoteId);
            CommonData.LOGGER.error("Failed to load emote!", throwable);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Animation parseAnimation(HttpResponse<InputStream> response) {
        try (InputStreamReader reader = new InputStreamReader(response.body());){
            Iterator<Map.Entry<String, Animation>> iterator;
            JsonObject obj = (JsonObject)EmoteResourcePack.GSON.fromJson((Reader)reader, JsonObject.class);
            if (!obj.has("present")) throw new NullPointerException(JsonUtil.getAsString(obj, "message", "Animation is not present!"));
            if (!obj.get("present").getAsBoolean()) {
                throw new NullPointerException(JsonUtil.getAsString(obj, "message", "Animation is not present!"));
            }
            if (obj.has("message")) {
                CommonData.LOGGER.warn(obj.get("message").getAsString());
            }
            if (!(iterator = UniversalAnimLoader.loadAnimations(obj.getAsJsonObject("emotes")).entrySet().iterator()).hasNext()) throw new NullPointerException();
            Map.Entry<String, Animation> animation = iterator.next();
            Animation animation2 = animation.getValue();
            return animation2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void preloadEmotes(List<UUID> emotes) {
        for (UUID emoteId : emotes) {
            CommonData.LOGGER.debug("Preloading emote {}...", (Object)emoteId);
            try {
                BEDROCK_KEYFRAMES.get((Object)emoteId.toString());
            }
            catch (Throwable th) {
                CommonData.LOGGER.error("Failed to preload emote: {}", (Object)emoteId, (Object)th);
            }
        }
    }

    public static CompletableFuture<Animation> loadEmote(String emoteId) {
        try {
            return (CompletableFuture)BEDROCK_KEYFRAMES.get((Object)emoteId);
        }
        catch (Throwable th) {
            return CompletableFuture.failedFuture(th);
        }
    }
}

