/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.fuckery.relocation;

import com.zigythebird.playeranim.lib.ow.asm.commons.Remapper;
import java.io.File;
import java.net.URI;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.jar.JarFile;

public final class GeyserRelocationIndex
extends Remapper {
    private final Map<String, String> rootToTarget;
    private final Function<String, Boolean> hasOwnClass;
    private static final String GEYSER_SHADED_BASE = "org/geysermc/geyser/shaded/";
    private static final String GEYSER_PLATFORM_BASE = "org/geysermc/geyser/platform/";
    private static final String SHADED_SEGMENT = "shaded/";

    private GeyserRelocationIndex(Map<String, String> rootToTarget, Function<String, Boolean> hasOwnClass) {
        super(589824);
        this.rootToTarget = rootToTarget;
        this.hasOwnClass = hasOwnClass;
    }

    public static GeyserRelocationIndex fromGeyserJar(Class<?> geyserAnchor, Function<String, Boolean> hasOwnClass) {
        File jarFile = GeyserRelocationIndex.jarFileOf(geyserAnchor);
        HashMap<String, String> map = new HashMap<String, String>(512);
        try (JarFile jar = new JarFile(jarFile);){
            jar.stream().forEach(e -> {
                String n = e.getName();
                if (!n.endsWith(".class")) {
                    return;
                }
                if (n.startsWith(GEYSER_SHADED_BASE)) {
                    int canonStart = GEYSER_SHADED_BASE.length();
                    GeyserRelocationIndex.addRoot(map, "org/geysermc/geyser/", n, canonStart);
                    return;
                }
                if (n.startsWith(GEYSER_PLATFORM_BASE)) {
                    int p = GEYSER_PLATFORM_BASE.length();
                    int platformSlash = n.indexOf(47, p);
                    if (platformSlash < 0) {
                        return;
                    }
                    int shadedStart = platformSlash + 1;
                    if (!n.regionMatches(shadedStart, SHADED_SEGMENT, 0, SHADED_SEGMENT.length())) {
                        return;
                    }
                    int canonStart = shadedStart + SHADED_SEGMENT.length();
                    String prefixBeforeShaded = n.substring(0, shadedStart);
                    GeyserRelocationIndex.addRoot(map, prefixBeforeShaded, n, canonStart);
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to index Geyser relocations from " + String.valueOf(jarFile), ex);
        }
        return new GeyserRelocationIndex(map, hasOwnClass);
    }

    @Override
    public String map(String internalName) {
        if (internalName == null) {
            return null;
        }
        if (this.hasOwnClass.apply(internalName).booleanValue()) {
            return internalName;
        }
        String root = GeyserRelocationIndex.twoSegmentRoot(internalName);
        if (root == null) {
            return internalName;
        }
        String targetRoot = this.rootToTarget.get(root);
        if (targetRoot == null) {
            return internalName;
        }
        return targetRoot + internalName.substring(root.length());
    }

    public boolean isEmpty() {
        return this.rootToTarget.isEmpty();
    }

    private static void addRoot(Map<String, String> map, String prefixBeforeShaded, String fullEntry, int canonStart) {
        int firstSlash = fullEntry.indexOf(47, canonStart);
        if (firstSlash < 0) {
            return;
        }
        int secondSlash = fullEntry.indexOf(47, firstSlash + 1);
        if (secondSlash < 0) {
            return;
        }
        String root = fullEntry.substring(canonStart, secondSlash + 1);
        map.putIfAbsent(root, prefixBeforeShaded + SHADED_SEGMENT + root);
    }

    private static String twoSegmentRoot(String internalName) {
        int first = internalName.indexOf(47);
        if (first < 0) {
            return null;
        }
        int second = internalName.indexOf(47, first + 1);
        if (second < 0) {
            return null;
        }
        return internalName.substring(0, second + 1);
    }

    private static File jarFileOf(Class<?> anchor) {
        try {
            CodeSource cs = anchor.getProtectionDomain().getCodeSource();
            if (cs == null) {
                throw new IllegalStateException("No CodeSource for " + anchor.getName());
            }
            URI uri = cs.getLocation().toURI();
            File f = new File(uri);
            if (!f.isFile()) {
                throw new IllegalStateException("Not a jar: " + String.valueOf(f));
            }
            return f;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot locate jar for " + anchor.getName(), e);
        }
    }

    public String toString() {
        return this.rootToTarget.toString();
    }
}

