/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.mcsp2.model;

import java.util.HashMap;
import java.util.Map;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Layer;
import net.raphimc.noteblocklib.model.Song;

public class McSp2Song
extends Song {
    private int tempo = 10;
    private int autoSaveInterval;
    private int leftClicks;
    private int rightClicks;
    private int noteBlocksAdded;
    private int noteBlocksRemoved;
    private int minutesSpent;
    private final Map<Integer, McSp2Layer> layers = new HashMap<Integer, McSp2Layer>();

    public McSp2Song() {
        this(null);
    }

    public McSp2Song(String fileName) {
        super(SongFormat.MCSP, fileName);
    }

    public int getTempo() {
        return this.tempo;
    }

    public McSp2Song setTempo(int tempo) {
        this.tempo = tempo;
        return this;
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public McSp2Song setAutoSaveInterval(int autoSaveInterval) {
        this.autoSaveInterval = autoSaveInterval;
        return this;
    }

    public int getLeftClicks() {
        return this.leftClicks;
    }

    public McSp2Song setLeftClicks(int leftClicks) {
        this.leftClicks = leftClicks;
        return this;
    }

    public int getRightClicks() {
        return this.rightClicks;
    }

    public McSp2Song setRightClicks(int rightClicks) {
        this.rightClicks = rightClicks;
        return this;
    }

    public int getNoteBlocksAdded() {
        return this.noteBlocksAdded;
    }

    public McSp2Song setNoteBlocksAdded(int noteBlocksAdded) {
        this.noteBlocksAdded = noteBlocksAdded;
        return this;
    }

    public int getNoteBlocksRemoved() {
        return this.noteBlocksRemoved;
    }

    public McSp2Song setNoteBlocksRemoved(int noteBlocksRemoved) {
        this.noteBlocksRemoved = noteBlocksRemoved;
        return this;
    }

    public int getMinutesSpent() {
        return this.minutesSpent;
    }

    public McSp2Song setMinutesSpent(int minutesSpent) {
        this.minutesSpent = minutesSpent;
        return this;
    }

    public Map<Integer, McSp2Layer> getLayers() {
        return this.layers;
    }

    @Override
    public McSp2Song copy() {
        McSp2Song copySong = new McSp2Song(this.getFileName());
        copySong.copyGeneralData(this);
        copySong.setTempo(this.getTempo());
        copySong.setAutoSaveInterval(this.getAutoSaveInterval());
        copySong.setMinutesSpent(this.getMinutesSpent());
        copySong.setLeftClicks(this.getLeftClicks());
        copySong.setRightClicks(this.getRightClicks());
        copySong.setNoteBlocksAdded(this.getNoteBlocksAdded());
        copySong.setNoteBlocksRemoved(this.getNoteBlocksRemoved());
        Map<Integer, McSp2Layer> layers = this.getLayers();
        Map<Integer, McSp2Layer> copyLayers = copySong.getLayers();
        for (Map.Entry<Integer, McSp2Layer> entry : layers.entrySet()) {
            copyLayers.put(entry.getKey(), entry.getValue().copy());
        }
        return copySong;
    }
}

