/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.mcsp2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.mcsp2.McSp2Definitions;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Layer;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Note;
import net.raphimc.noteblocklib.format.mcsp2.model.McSp2Song;
import net.raphimc.noteblocklib.model.Note;

public class McSp2Io {
    private static final int BUFFER_SIZE = 0x100000;

    public static McSp2Song readSong(InputStream is, String fileName) {
        Scanner scanner = new Scanner((InputStream)new BufferedInputStream(is, 0x100000), StandardCharsets.ISO_8859_1.name()).useDelimiter("[|\\n]");
        McSp2Song song = new McSp2Song(fileName);
        scanner.nextInt();
        Map<Integer, McSp2Layer> layers = song.getLayers();
        song.setAutoSaveInterval(scanner.nextInt());
        song.setTitle(scanner.next());
        song.setAuthor(scanner.next());
        song.setOriginalAuthor(scanner.next());
        if (!scanner.next().isEmpty()) {
            throw new IllegalStateException("Invalid MCSP2 header");
        }
        int tick = 0;
        while (scanner.hasNext()) {
            tick += scanner.nextInt();
            Matcher noteData = McSp2Definitions.NOTE_DATA_PATTERN.matcher(scanner.next());
            int layer = 0;
            while (noteData.find()) {
                if (noteData.groupCount() == 2) {
                    layers.computeIfAbsent(layer += Integer.parseInt(noteData.group(1)), k -> new McSp2Layer()).getNotes().put(tick, new McSp2Note().setInstrumentAndKey(noteData.group(2).charAt(0)));
                    continue;
                }
                if (noteData.groupCount() == 1) {
                    layers.computeIfAbsent(layer, k -> new McSp2Layer()).getNotes().put(tick, new McSp2Note().setInstrumentAndKey(noteData.group(1).charAt(0)));
                    continue;
                }
                if (noteData.groupCount() == 0) continue;
                throw new IllegalArgumentException("Invalid note data: " + noteData.group(0));
            }
        }
        try {
            scanner.nextLine();
            song.setTempo(scanner.nextInt());
            song.setLeftClicks(scanner.nextInt());
            song.setRightClicks(scanner.nextInt());
            song.setNoteBlocksAdded(scanner.nextInt());
            song.setNoteBlocksRemoved(scanner.nextInt());
            song.setMinutesSpent(scanner.nextInt());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        song.getTempoEvents().set(0, song.getTempo());
        for (McSp2Layer layer : song.getLayers().values()) {
            for (Map.Entry<Integer, McSp2Note> noteEntry : layer.getNotes().entrySet()) {
                McSp2Note mcSp2Note = noteEntry.getValue();
                Note note = new Note();
                note.setInstrument(MinecraftInstrument.fromNbsId(mcSp2Note.getInstrument()));
                note.setMcKey(mcSp2Note.getKey());
                song.getNotes().add((int)noteEntry.getKey(), note);
            }
        }
        return song;
    }

    public static void writeSong(McSp2Song song, OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os, 0x100000), StandardCharsets.ISO_8859_1);
        writer.write("2");
        writer.write("|");
        writer.write(String.valueOf(song.getAutoSaveInterval()));
        writer.write("|");
        writer.write(song.getTitleOr("").replace("|", "_"));
        writer.write("|");
        writer.write(song.getAuthorOr("").replace("|", "_"));
        writer.write("|");
        writer.write(song.getOriginalAuthorOr("").replace("|", "_"));
        writer.write("|");
        TreeMap<Integer, Map> notes = new TreeMap<Integer, Map>();
        for (Map.Entry<Integer, McSp2Layer> layerEntry : song.getLayers().entrySet()) {
            for (Map.Entry<Integer, McSp2Note> noteEntry : layerEntry.getValue().getNotes().entrySet()) {
                notes.computeIfAbsent(noteEntry.getKey(), k -> new TreeMap()).put(layerEntry.getKey(), noteEntry.getValue());
            }
        }
        int lastTick = 0;
        for (Map.Entry tickEntry : notes.entrySet()) {
            writer.write("|");
            writer.write(String.valueOf((Integer)tickEntry.getKey() - lastTick));
            lastTick = (Integer)tickEntry.getKey();
            int lastLayer = 0;
            StringBuilder noteData = new StringBuilder();
            for (Map.Entry layerEntry : ((Map)tickEntry.getValue()).entrySet()) {
                noteData.append((Integer)layerEntry.getKey() - lastLayer);
                noteData.append('>');
                noteData.append(((McSp2Note)layerEntry.getValue()).getInstrumentAndKey());
                lastLayer = (Integer)layerEntry.getKey();
            }
            writer.write("|");
            writer.write(noteData.toString());
        }
        writer.write("\n");
        writer.write(String.valueOf(song.getTempo()));
        writer.write("|");
        writer.write(String.valueOf(song.getLeftClicks()));
        writer.write("|");
        writer.write(String.valueOf(song.getRightClicks()));
        writer.write("|");
        writer.write(String.valueOf(song.getNoteBlocksAdded()));
        writer.write("|");
        writer.write(String.valueOf(song.getNoteBlocksRemoved()));
        writer.write("|");
        writer.write(String.valueOf(song.getMinutesSpent()));
        writer.flush();
    }
}

