/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranim.lib.mochafloats.parser.ast;

import com.zigythebird.playeranim.lib.mochafloats.parser.ast.Expression;
import com.zigythebird.playeranim.lib.mochafloats.parser.ast.ExpressionVisitor;
import com.zigythebird.playeranim.lib.mochafloats.util.ExprBytesUtils;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class TernaryConditionalExpression
implements Expression {
    private Expression conditional;
    private Expression trueExpression;
    private Expression falseExpression;

    public TernaryConditionalExpression(ByteBuf buf) {
        this(ExprBytesUtils.readExpression(buf), ExprBytesUtils.readExpression(buf), ExprBytesUtils.readExpression(buf));
    }

    public TernaryConditionalExpression(@NotNull Expression conditional, @NotNull Expression trueExpression, @NotNull Expression falseExpression) {
        this.conditional = Objects.requireNonNull(conditional, "conditional");
        this.trueExpression = Objects.requireNonNull(trueExpression, "trueExpression");
        this.falseExpression = Objects.requireNonNull(falseExpression, "falseExpression");
    }

    @NotNull
    public Expression condition() {
        return this.conditional;
    }

    public void condition(@NotNull Expression condition) {
        this.conditional = Objects.requireNonNull(condition, "condition");
    }

    @NotNull
    public Expression trueExpression() {
        return this.trueExpression;
    }

    public void trueExpression(@NotNull Expression trueExpression) {
        this.trueExpression = Objects.requireNonNull(trueExpression, "trueExpression");
    }

    @NotNull
    public Expression falseExpression() {
        return this.falseExpression;
    }

    public void falseExpression(@NotNull Expression falseExpression) {
        this.falseExpression = Objects.requireNonNull(falseExpression, "falseExpression");
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitTernaryConditional(this);
    }

    @Override
    public void write(ByteBuf buf) {
        ExprBytesUtils.writeExpression(this.conditional, buf);
        ExprBytesUtils.writeExpression(this.trueExpression, buf);
        ExprBytesUtils.writeExpression(this.falseExpression, buf);
    }

    public String toString() {
        return String.format("(%s)?%s:%s", this.conditional, this.trueExpression, this.falseExpression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TernaryConditionalExpression that = (TernaryConditionalExpression)o;
        return this.conditional.equals(that.conditional) && this.trueExpression.equals(that.trueExpression) && this.falseExpression.equals(that.falseExpression);
    }

    public int hashCode() {
        return Objects.hash(this.conditional, this.trueExpression, this.falseExpression);
    }
}

