/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.utils;

import java.util.UUID;
import org.geysermc.geyser.api.entity.type.player.GeyserPlayerEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.jspecify.annotations.Nullable;

public class GeyserEntityUtils {
    public static @Nullable AvatarEntity getAvatarByUUID(GeyserSession session, UUID uuid) {
        AvatarEntity player;
        GeyserPlayerEntity geyserPlayerEntity = session.entities().playerEntity();
        if (geyserPlayerEntity instanceof AvatarEntity && (player = (AvatarEntity)geyserPlayerEntity).getUuid().equals(uuid)) {
            return player;
        }
        player = session.getEntityCache().getPlayerEntity(uuid);
        if (player != null) {
            return player;
        }
        for (Entity entity : session.getEntityCache().getEntities().values()) {
            AvatarEntity avatar;
            if (!(entity instanceof AvatarEntity) || !(avatar = (AvatarEntity)entity).getUuid().equals(uuid)) continue;
            return avatar;
        }
        return null;
    }

    public static boolean unsubscribedFromEntity(AvatarEntity entity) {
        GeyserSession session = entity.getSession();
        if (session.isClosed()) {
            return true;
        }
        if (session.entities().playerEntity() == entity) {
            return false;
        }
        return session.getEntityCache().getEntityByGeyserId(entity.getGeyserId()) == null;
    }
}

