/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.animator;

import com.google.common.collect.Sets;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.HumanoidAnimationController;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.enums.Axis;
import com.zigythebird.playeranimcore.enums.PlayState;
import com.zigythebird.playeranimcore.enums.TransformType;
import com.zigythebird.playeranimcore.molang.MolangLoader;
import com.zigythebird.playeranimcore.util.MatrixUtil;
import io.github.kosmx.emotes.common.CommonData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.entity.property.GeyserEntityProperty;
import org.geysermc.geyser.api.entity.property.type.GeyserIntEntityProperty;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.redlance.dima_dencep.mods.emotecraft.geyser.EmotecraftExt;
import org.redlance.dima_dencep.mods.emotecraft.geyser.animator.PackedProperty;
import org.redlance.dima_dencep.mods.emotecraft.geyser.animator.geometry.BendingGeometry;
import org.redlance.dima_dencep.mods.emotecraft.geyser.animator.geometry.GeometryChanger;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.BedrockPacketsUtils;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.GeyserEntityUtils;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.resourcepack.EmoteResourcePack;

public class GeyserAnimationController
extends HumanoidAnimationController {
    private static final long LEASE_MS = 10L;
    private final Map<Identifier, Long> lastUsedProperties = new ConcurrentHashMap<Identifier, Long>(1);
    protected final Set<AvatarEntity> listeners = Sets.newConcurrentHashSet();
    private final Set<String> dirtyBones = new HashSet<String>();
    protected final UUID avatarId;

    protected GeyserAnimationController(UUID avatarId) {
        super((controller, state, animationSetter) -> PlayState.STOP, MolangLoader::createNewEngine);
        this.avatarId = avatarId;
    }

    @Override
    protected void setupNewAnimation() {
        super.setupNewAnimation();
        for (AvatarEntity avatar : this.listeners) {
            this.subscribe(avatar);
        }
        this.dirtyBones.clear();
    }

    public void subscribe(AvatarEntity avatarEntity) {
        if (this.listeners.add(avatarEntity) && !EmotecraftExt.getNetworkInstance((GeyserConnection)avatarEntity.getSession()).appliedGeometries.contains(avatarEntity.getGeyserId())) {
            try {
                GeometryChanger.changeGeometryToBending(avatarEntity).join();
            }
            catch (Throwable th) {
                CommonData.LOGGER.warn("Failed to apply geometry!", th);
            }
        }
        for (String partKey : this.dirtyBones) {
            this.updateBone(avatarEntity, partKey, new PlayerAnimBone(partKey));
        }
    }

    protected void handleFrameInternal() {
        try {
            AnimationData data = new AnimationData(0.0f, 1.0f, false);
            this.tick(data);
            if (!this.isActive()) {
                return;
            }
            this.setupAnim(data);
            for (String partKey : this.activeBones.keySet()) {
                if (!this.bones.containsKey(partKey)) {
                    CommonData.LOGGER.debug("Unsupported bone: {}!", (Object)partKey);
                    continue;
                }
                PlayerAnimBone bone = this.get3DTransform(new PlayerAnimBone(partKey));
                for (AvatarEntity avatarEntity : this.listeners) {
                    if (GeyserEntityUtils.unsubscribedFromEntity(avatarEntity)) {
                        this.unsubscribe(avatarEntity);
                        continue;
                    }
                    if (this.isActive()) {
                        BedrockPacketsUtils.sendInstantAnimation(EmoteResourcePack.ANIMATION_NAME, avatarEntity);
                    }
                    this.updateBone(avatarEntity, partKey, bone);
                }
            }
            if (this.dirtyBones.isEmpty()) {
                this.dirtyBones.addAll(this.activeBones.keySet());
            }
        }
        catch (Throwable th) {
            CommonData.LOGGER.warn("Failed to animate {}!", (Object)this.avatarId, (Object)th);
        }
    }

    protected boolean handleFrame() {
        this.handleFrameInternal();
        this.listeners.removeIf(GeyserEntityUtils::unsubscribedFromEntity);
        return this.listeners.isEmpty();
    }

    @Override
    public PlayerAnimBone get3DTransform(@NonNull PlayerAnimBone bone) {
        String boneName = (bone = super.get3DTransform(bone)).getName();
        if ("left_arm".equals(boneName) || "right_arm".equals(boneName) || "head".equals(boneName)) {
            PlayerAnimBone torsoBone = this.get3DTransform(new PlayerAnimBone("torso"));
            torsoBone.mulPos(-1.0f);
            torsoBone.mulRot(-1.0f);
            torsoBone.setScaleX(1.0f / bone.getScaleX());
            torsoBone.setScaleY(1.0f / bone.getScaleY());
            torsoBone.setScaleZ(1.0f / bone.getScaleZ());
            MatrixUtil.applyParentsToChild(bone, Collections.singleton(torsoBone), this::getBonePosition);
        } else if ("left_leg".equals(boneName) || "right_leg".equals(boneName)) {
            PlayerAnimBone body = this.get3DTransform(new PlayerAnimBone("body"));
            MatrixUtil.applyParentsToChild(bone, Collections.singleton(body), this::getBonePosition);
        } else if ("cape".equals(boneName)) {
            bone.rotX *= -1.0f;
        }
        return bone;
    }

    protected void updateBone(AvatarEntity avatarEntity, String partKey, PlayerAnimBone bone) {
        if (!this.bones.containsKey(partKey)) {
            return;
        }
        this.updateAxis(avatarEntity, partKey, TransformType.POSITION, bone.getPosX(), bone.getPosY(), bone.getPosZ());
        this.updateAxis(avatarEntity, partKey, TransformType.ROTATION, (float)Math.toDegrees(bone.getRotX()), (float)Math.toDegrees(bone.getRotY()), (float)Math.toDegrees(bone.getRotZ()));
        this.updateAxis(avatarEntity, partKey, TransformType.SCALE, bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        if (BendingGeometry.BENDABLE_BONES.contains(partKey)) {
            this.updateBend(avatarEntity, partKey + "_bend", bone.bend);
        }
    }

    protected void updateAxis(AvatarEntity avatarEntity, String partKey, TransformType type, float x, float y, float z) {
        Map<Axis, Integer> ids = EmotecraftExt.getInstance().getResourcePack().getAxisIds(partKey, type);
        this.updateProperty(avatarEntity, PackedProperty.pack(ids.get((Object)Axis.X), x));
        this.updateProperty(avatarEntity, PackedProperty.pack(ids.get((Object)Axis.Y), y));
        this.updateProperty(avatarEntity, PackedProperty.pack(ids.get((Object)Axis.Z), z));
    }

    protected void updateBend(AvatarEntity avatarEntity, String partKey, float bend) {
        EmoteResourcePack resourcePack = EmotecraftExt.getInstance().getResourcePack();
        this.updateProperty(avatarEntity, PackedProperty.pack(resourcePack.getAxisIds(partKey, TransformType.ROTATION).get((Object)Axis.X), (float)Math.toDegrees(bend)));
        float radius = 2.0f;
        float angle = Math.abs(bend);
        this.updateProperty(avatarEntity, PackedProperty.pack(resourcePack.getAxisIds(partKey, TransformType.POSITION).get((Object)Axis.Y), (float)((double)radius * (1.0 - Math.cos(angle)))));
        this.updateProperty(avatarEntity, PackedProperty.pack(resourcePack.getAxisIds(partKey, TransformType.POSITION).get((Object)Axis.Z), (float)(-((double)radius * Math.sin(angle)))));
    }

    private GeyserIntEntityProperty getAvailableProperty() {
        while (true) {
            long now = System.currentTimeMillis();
            for (GeyserIntEntityProperty property : EmotecraftExt.getInstance().getResourcePack().getRegisteredProperties()) {
                if (this.lastUsedProperties.putIfAbsent(property.identifier(), now) != null) continue;
                return property;
            }
            long sleepMs = Long.MAX_VALUE;
            boolean removedAny = false;
            for (Map.Entry<Identifier, Long> e : this.lastUsedProperties.entrySet()) {
                long remaining = 10L - (now - e.getValue());
                if (remaining <= 0L) {
                    removedAny |= this.lastUsedProperties.remove(e.getKey(), e.getValue());
                    continue;
                }
                if (remaining >= sleepMs) continue;
                sleepMs = remaining;
            }
            if (removedAny || sleepMs == Long.MAX_VALUE) continue;
            try {
                Thread.sleep(sleepMs);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void updateProperty(AvatarEntity avatarEntity, int value) {
        avatarEntity.updatePropertiesBatched(updater -> updater.update((GeyserEntityProperty)this.getAvailableProperty(), (Object)value), true);
    }

    @Override
    public void process(AnimationData state) {
        super.process(state);
        if (!this.animationState.isActive()) {
            this.internalStop();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.internalStop();
    }

    protected void internalStop() {
        for (AvatarEntity avatarEntity : this.listeners) {
            BedrockPacketsUtils.sendBobAnimation(avatarEntity);
        }
    }

    public void unsubscribe(AvatarEntity avatarEntity) {
        if (this.listeners.remove(avatarEntity)) {
            BedrockPacketsUtils.sendBobAnimation(avatarEntity);
        }
    }

    public static Collection<String> getRegisteredBones() {
        GeyserAnimationController controller = new GeyserAnimationController(UUID.randomUUID());
        HashSet bones = new HashSet(controller.bones.keySet());
        for (String bendable : BendingGeometry.BENDABLE_BONES) {
            bones.add(bendable + "_bend");
        }
        return Collections.unmodifiableCollection(bones);
    }
}

