/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser;

import com.zigythebird.playeranim.lib.javassist.ByteArrayClassPath;
import com.zigythebird.playeranim.lib.javassist.ClassPool;
import com.zigythebird.playeranim.lib.javassist.CtClass;
import com.zigythebird.playeranim.lib.javassist.CtMethod;
import io.github.kosmx.emotes.common.CommonData;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.geysermc.geyser.extension.GeyserExtensionContainer;
import org.geysermc.geyser.platform.standalone.GeyserStandaloneBootstrap;
import org.redlance.common.utils.ReflectUtils;

public class GeyserBootstrap {
    private static final Class<?> LEVEL_CLASS = ReflectUtils.uncheck(() -> Class.forName("org.apache.logging.log4j.Level"));
    private static final MethodHandle SET_LEVEL = ReflectUtils.uncheck(() -> ReflectUtils.TRUSTED_LOOKUP.findStatic(Class.forName("org.apache.logging.log4j.core.config.Configurator"), "setLevel", MethodType.methodType(Void.TYPE, String.class, LEVEL_CLASS)));
    private static final MethodHandle DEBUG_LEVEL = ReflectUtils.uncheck(() -> ReflectUtils.TRUSTED_LOOKUP.findStaticGetter(LEVEL_CLASS, "DEBUG", LEVEL_CLASS));

    public static void main(String[] args) throws ReflectiveOperationException, IOException {
        GeyserBootstrap.patchClass(GeyserExtensionContainer.class, "org/geysermc/geyser/extension/GeyserExtensionLoader.class", GeyserBootstrap::patch);
        GeyserStandaloneBootstrap.main((String[])args);
    }

    private static byte[] patch(byte[] bytes) {
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath(new ByteArrayClassPath("org.geysermc.geyser.extension.GeyserExtensionLoader", bytes));
        try {
            CtClass cc = pool.get("org.geysermc.geyser.extension.GeyserExtensionLoader");
            CtMethod method = cc.getDeclaredMethod("loadAllExtensions");
            String src = "org.redlance.dima_dencep.mods.emotecraft.geyser.EmotecraftExt extension = new org.redlance.dima_dencep.mods.emotecraft.geyser.EmotecraftExt();\ntry {\n    java.io.InputStreamReader reader = new java.io.InputStreamReader(org.redlance.dima_dencep.mods.emotecraft.geyser.EmotecraftExt.class.getResourceAsStream(\"/extension.yml\"));\n    org.geysermc.geyser.extension.GeyserExtensionDescription description = org.geysermc.geyser.extension.GeyserExtensionDescription.fromYaml(reader);\n    reader.close();\n\n    java.nio.file.Path path = this.extensionsDirectory.resolve(description.id());\n    org.geysermc.geyser.api.event.EventBus eventBus = org.geysermc.geyser.GeyserImpl.getInstance().eventBus();\n    org.geysermc.geyser.extension.event.GeyserExtensionEventBus extensionEventBus = new org.geysermc.geyser.extension.event.GeyserExtensionEventBus(eventBus, extension);\n    org.geysermc.geyser.extension.GeyserExtensionContainer container = this.setup(extension, description, path, extensionEventBus);\n\n    this.extensionContainers.put(extension, container);\n    this.register(extension, $1);\n} catch (Throwable t) {\n    throw new RuntimeException(t);\n}";
            method.insertAfter(src, false);
            return cc.toBytecode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void patchClass(Class<?> nearClass, String name, UnaryOperator<byte[]> patcher) throws ReflectiveOperationException, IOException {
        try (InputStream is = Objects.requireNonNull(nearClass.getClassLoader().getResourceAsStream(name));){
            byte[] bytecode = (byte[])patcher.apply(is.readAllBytes());
            MethodHandles.privateLookupIn(nearClass, MethodHandles.lookup()).defineClass(bytecode);
        }
    }

    static {
        System.setProperty("java.awt.headless", "true");
        try {
            SET_LEVEL.invoke(CommonData.LOGGER.getName(), DEBUG_LEVEL.invoke());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

