/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser;

import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.server.config.ConfigSerializer;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.packet.EmoteListPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.event.PostOrder;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.command.CommandExecutor;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.event.bedrock.ClientEmoteEvent;
import org.geysermc.geyser.api.event.bedrock.SessionDisconnectEvent;
import org.geysermc.geyser.api.event.bedrock.SessionInitializeEvent;
import org.geysermc.geyser.api.event.bedrock.SessionSkinApplyEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCommandsEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPreInitializeEvent;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.pack.GeyserResourcePackManifest;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundCustomPayloadPacket;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundCustomPayloadPacket;
import org.redlance.dima_dencep.mods.emotecraft.geyser.animator.geometry.BendingGeometry;
import org.redlance.dima_dencep.mods.emotecraft.geyser.commands.FixGeometryCommand;
import org.redlance.dima_dencep.mods.emotecraft.geyser.fuckery.GayserHacks;
import org.redlance.dima_dencep.mods.emotecraft.geyser.fuckery.ProtocolUtils;
import org.redlance.dima_dencep.mods.emotecraft.geyser.handler.ConnectionType;
import org.redlance.dima_dencep.mods.emotecraft.geyser.handler.GeyserNetworkInstance;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.BedrockEmoteLoader;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.DinnerboneProtocolUtils;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.GeyserEntityUtils;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.resourcepack.EmoteResourcePack;

public class EmotecraftExt
implements Extension {
    private static final Map<GeyserConnection, GeyserNetworkInstance> INSTANCES = new ConcurrentHashMap<GeyserConnection, GeyserNetworkInstance>();
    public static final Key MINECRAFT_REGISTER_TYPE = MinecraftKey.key((String)"register");
    public static final Key EMOTECRAFT_EMOTE_TYPE = Key.key((String)"emotecraft", (String)"emote");
    public static final Key EMOTECRAFT_STREAM_TYPE = Key.key((String)"emotecraft", (String)"stream");
    private static final Set<Key> EMOTECRAFT_CHANNELS = Set.of(EMOTECRAFT_EMOTE_TYPE, EMOTECRAFT_STREAM_TYPE);
    private final EmoteResourcePack resourcePack = new EmoteResourcePack(new GeyserResourcePackManifest.Version(1, 0, 0), "Emotecraft", "Emotecraft");
    private static EmotecraftExt instance;

    public EmotecraftExt() {
        instance = this;
    }

    @Subscribe
    public void onPreInitialize(GeyserPreInitializeEvent event) {
        this.eventBus().register((Object)this.resourcePack);
    }

    @Subscribe(postOrder=PostOrder.LAST)
    public void onPostInitialize(GeyserPostInitializeEvent event) {
        int javaVersion;
        CommonData.LOGGER.info("Loading emotecraft on geyser...");
        CommonData.LOGGER.warn("Note that this extension does some horrible hacks on geyser.");
        CommonData.LOGGER.warn("Until custom packet event is added, workarounds cannot be avoided.");
        Serializer.INSTANCE = new Serializer(new ConfigSerializer(SerializableConfig::new), SerializableConfig.class);
        UniversalEmoteSerializer.loadEmotes();
        GayserHacks.addCustomJavaTranslator(ClientboundCustomPayloadPacket.class, (session, packet) -> {
            Key type = packet.getChannel();
            if ("emotecraft".equals(type.namespace())) {
                this.onEmotecraftPayload((GeyserConnection)session, packet.getChannel(), packet.getData());
                return false;
            }
            if (MINECRAFT_REGISTER_TYPE.equals((Object)type)) {
                this.onMinecraftRegisterPayload(session, packet.getChannel(), packet.getData());
            }
            return true;
        });
        GayserHacks.addCustomBedrockTranslator(PlayerAuthInputPacket.class, (session, packet) -> {
            GeyserNetworkInstance networkInstance = INSTANCES.get(session);
            if (networkInstance != null && networkInstance.isPlaying() && session.isSneaking()) {
                CommonData.LOGGER.debug("Stopping animation {}", (Object)session.name());
                networkInstance.stopEmote((AvatarEntity)session.getPlayerEntity(), null);
            }
            return true;
        });
        GayserHacks.addCustomBedrockTranslator(EmoteListPacket.class, (session, packet) -> {
            BedrockEmoteLoader.preloadEmotes(packet.getPieceIds());
            return true;
        });
        int recommendedJava = 21;
        for (int i = javaVersion = Runtime.version().feature(); i < 21; ++i) {
            CommonData.LOGGER.error("You are running Java {}, but Java {} or newer is recommended!", (Object)javaVersion, (Object)21);
        }
    }

    private void onMinecraftRegisterPayload(GeyserSession session, Key type, byte[] bytes) {
        ByteBuf inputByteBuf = Unpooled.wrappedBuffer((byte[])bytes);
        Set<Key> channels = DinnerboneProtocolUtils.readChannels(inputByteBuf);
        inputByteBuf.release();
        CommonData.LOGGER.debug("Server listening channels: {}", channels);
        if (channels.contains(EMOTECRAFT_EMOTE_TYPE)) {
            GeyserNetworkInstance networkInstance;
            CommonData.LOGGER.debug("Has emotecraft!");
            ByteBuf byteBuf = Unpooled.buffer();
            DinnerboneProtocolUtils.writeChannels(byteBuf, EMOTECRAFT_CHANNELS);
            session.sendDownstreamPacket((Packet)new ServerboundCustomPayloadPacket(type, MathHelper.readBytes((ByteBuf)byteBuf)));
            byteBuf.release();
            if (ProtocolUtils.getProtocol(session).getOutboundState() == ProtocolState.GAME && (networkInstance = INSTANCES.get(session)).getConnectionType() == ConnectionType.NONE) {
                CommonData.LOGGER.warn("The server failed to configure the client, attempting to configure...");
                networkInstance.sendC2SConfig();
            }
        }
    }

    private void onEmotecraftPayload(GeyserConnection session, Key channel, byte[] bytes) {
        GeyserNetworkInstance networkInstance = EmotecraftExt.getNetworkInstance(session);
        if (networkInstance.getConnectionType() == ConnectionType.NONE) {
            if (ProtocolUtils.getProtocol((GeyserSession)session).getOutboundState() == ProtocolState.CONFIGURATION) {
                CommonData.LOGGER.debug("Configuring emotecraft...");
                networkInstance.sendC2SConfig();
            }
            networkInstance.setConnectionType(ConnectionType.BACKEND);
        }
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
        networkInstance.receiveMessage(new EmotePacket(byteBuf));
        byteBuf.release();
    }

    @Subscribe
    public void onSessionInitialize(SessionInitializeEvent event) {
        GeyserConnection session = event.connection();
        INSTANCES.put(session, new GeyserNetworkInstance(session));
    }

    @Subscribe
    public void onSessionDisconnect(SessionDisconnectEvent event) {
        GeyserNetworkInstance instance = INSTANCES.remove(event.connection());
        if (instance != null) {
            instance.disconnect();
        }
    }

    public @NonNull String rootCommand() {
        return "emotes-geyser";
    }

    @Subscribe
    public void onDefineCommands(GeyserDefineCommandsEvent event) {
        event.register(Command.builder((Extension)this).name("list").bedrockOnly(true).source(GeyserConnection.class).aliases(Collections.singletonList("emotes")).description("List of emotes").playerOnly(true).executor((source, cmd, args) -> INSTANCES.get(source).showEmoteList()).build());
        event.register(Command.builder((Extension)this).name("fix-geometry").bedrockOnly(true).source(GeyserConnection.class).aliases(Collections.singletonList("fix-bends")).description("Fix geometry").playerOnly(true).executor((CommandExecutor)new FixGeometryCommand()).build());
    }

    @Subscribe(postOrder=PostOrder.FIRST, ignoreCancelled=true)
    public void onEmote(ClientEmoteEvent event) {
        GeyserNetworkInstance networkInstance = INSTANCES.get(event.connection());
        if (networkInstance != null && networkInstance.getConnectionType() != ConnectionType.NONE) {
            CompletableFuture<Animation> animation = BedrockEmoteLoader.loadEmote(event.emoteId());
            if (animation.isDone() && !animation.isCompletedExceptionally()) {
                networkInstance.playEmote(animation.join(), 0.0f, null);
            } else {
                try {
                    networkInstance.stopEmote(UUID.fromString(event.emoteId()));
                }
                catch (IllegalArgumentException ex) {
                    networkInstance.stopEmote(null);
                }
                if (animation.isCompletedExceptionally()) {
                    networkInstance.sendChatMessage("emotecraft.blockedEmote");
                    CommonData.LOGGER.warn("Failed to translate emote!", animation.exceptionNow());
                } else {
                    animation.thenAccept(emote -> networkInstance.playEmote((Animation)emote, 0.0f, event.emoteId()));
                }
            }
            event.setCancelled(true);
        }
    }

    @Subscribe(postOrder=PostOrder.LAST, ignoreCancelled=true)
    public void onSessionSkinApply(SessionSkinApplyEvent event) {
        event.geometry(BendingGeometry.addBoneBends(event.skinData().geometry()));
        try {
            EmotecraftExt.getNetworkInstance((GeyserConnection)event.connection()).appliedGeometries.add(Objects.requireNonNull(GeyserEntityUtils.getAvatarByUUID((GeyserSession)event.connection(), event.uuid())).getGeyserId());
        }
        catch (Throwable th) {
            CommonData.LOGGER.warn("Failed to apply geomentry!", th);
        }
    }

    public EmoteResourcePack getResourcePack() {
        return this.resourcePack;
    }

    public static EmotecraftExt getInstance() {
        return instance;
    }

    public static GeyserNetworkInstance getNetworkInstance(GeyserConnection connection) {
        return INSTANCES.computeIfAbsent(connection, GeyserNetworkInstance::new);
    }
}

