/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.model;

import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeMap;

public class TempoEvents {
    private static final float DEFAULT_TEMPO = 20.0f;
    private final TreeMap<Integer, Float> tempoEvents = new TreeMap();

    public TempoEvents() {
        this.tempoEvents.put(0, Float.valueOf(20.0f));
    }

    public float get(int tick) {
        return this.tempoEvents.getOrDefault(tick, Float.valueOf(0.0f)).floatValue();
    }

    public float getEffectiveTempo(int tick) {
        Float tempo = this.tempoEvents.get(tick);
        if (tempo != null) {
            return tempo.floatValue();
        }
        return this.tempoEvents.floorEntry(tick).getValue().floatValue();
    }

    public void set(int tick, float tempo) {
        this.tempoEvents.put(tick, Float.valueOf(tempo));
    }

    public SortedSet<Integer> getTicks() {
        return Collections.unmodifiableSortedSet(this.tempoEvents.navigableKeySet());
    }

    public void remove(int tick) {
        if (tick == 0) {
            throw new IllegalArgumentException("Cannot remove the initial tempo event");
        }
        this.tempoEvents.remove(tick);
    }

    public void clear() {
        this.tempoEvents.clear();
        this.tempoEvents.put(0, Float.valueOf(20.0f));
    }

    public float[] getTempoRange() {
        float minTempo = this.tempoEvents.values().stream().min(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
        float maxTempo = this.tempoEvents.values().stream().max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
        return new float[]{minTempo, maxTempo};
    }

    public String getHumanReadableTempoRange() {
        float[] tempoRange = this.getTempoRange();
        return tempoRange[0] == tempoRange[1] ? String.format("%.2f", Float.valueOf(tempoRange[0])) : String.format("%.2f", Float.valueOf(tempoRange[0])) + " - " + String.format("%.2f", Float.valueOf(tempoRange[1]));
    }

    public TempoEvents copy() {
        TempoEvents copyTempoEvents = new TempoEvents();
        copyTempoEvents.tempoEvents.putAll(this.tempoEvents);
        return copyTempoEvents;
    }
}

