/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.utils.resourcepack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.zigythebird.playeranimcore.enums.Axis;
import com.zigythebird.playeranimcore.enums.TransformType;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import io.github.kosmx.emotes.common.CommonData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.event.PostOrder;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.api.entity.property.type.GeyserIntEntityProperty;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineEntityPropertiesEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineResourcePacksEvent;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.ResourcePackManifest;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.GeyserResourcePackManifest;
import org.redlance.dima_dencep.mods.emotecraft.geyser.animator.GeyserAnimationController;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.resourcepack.CollectionAdapter;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.resourcepack.ResourcePackVersionSerializer;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.resourcepack.SeekableInMemoryByteChannel;

public final class EmoteResourcePack
extends PackCodec
implements EventRegistrar {
    private static final Identifier PLAYER_IDENTIFIER = Identifier.of((String)"minecraft", (String)"player");
    public static final String ANIMATION_NAME = String.format("animation.%s", "emotecraft");
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(GeyserResourcePackManifest.Version.class, (Object)new ResourcePackVersionSerializer()).registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).disableHtmlEscaping().create();
    private final Map<String, EnumMap<TransformType, EnumMap<Axis, Integer>>> identifiers = new HashMap<String, EnumMap<TransformType, EnumMap<Axis, Integer>>>();
    private final Set<GeyserIntEntityProperty> registeredProperties = new HashSet<GeyserIntEntityProperty>(1);
    private final ResourcePackManifest manifest;
    private String molangScript;
    private byte[] packData;
    private byte[] sha256;

    public EmoteResourcePack(GeyserResourcePackManifest.Version version, String name, String description) {
        this((ResourcePackManifest)new GeyserResourcePackManifest(2, new GeyserResourcePackManifest.Header(UUID.randomUUID(), version, name, description, new GeyserResourcePackManifest.Version(1, 16, 0)), Collections.singleton(new GeyserResourcePackManifest.Module(UUID.randomUUID(), version, "resources", description)), null, null, null));
    }

    private EmoteResourcePack(ResourcePackManifest manifest) {
        this.manifest = manifest;
    }

    private JsonObject generateAnimation() {
        JsonObject bones = new JsonObject();
        int id = -98;
        this.identifiers.clear();
        for (String boneName : GeyserAnimationController.getRegisteredBones()) {
            String bedrockBone;
            JsonObject bone = new JsonObject();
            EnumMap transformType = this.identifiers.computeIfAbsent(boneName, k -> new EnumMap(TransformType.class));
            bone.add("rotation", (JsonElement)this.generateBone(true, id++, id++, id++, 0.0f, transformType.computeIfAbsent(TransformType.ROTATION, k -> new EnumMap(Axis.class))));
            bone.add("position", (JsonElement)this.generateBone(false, id++, id++, id++, 0.0f, transformType.computeIfAbsent(TransformType.POSITION, k -> new EnumMap(Axis.class))));
            if (!boneName.endsWith("_bend")) {
                bone.add("scale", (JsonElement)this.generateBone(false, id++, id++, id++, 1.0f, transformType.computeIfAbsent(TransformType.SCALE, k -> new EnumMap(Axis.class))));
            }
            if ("body".equals(bedrockBone = UniversalAnimLoader.restorePlayerBoneName((String)boneName))) {
                bedrockBone = "waist";
            }
            if ("torso".equals(bedrockBone)) {
                bedrockBone = "body";
            }
            bones.add(bedrockBone, (JsonElement)bone);
        }
        JsonObject animation = new JsonObject();
        animation.addProperty("animation_length", (Number)Float.valueOf(1.0f));
        animation.addProperty("loop", Boolean.valueOf(true));
        animation.addProperty("override_previous_animation", Boolean.valueOf(true));
        animation.add("bones", (JsonElement)bones);
        JsonObject container = new JsonObject();
        container.add(ANIMATION_NAME, (JsonElement)animation);
        JsonObject parent = new JsonObject();
        parent.add("animations", (JsonElement)container);
        parent.addProperty("format_version", "1.8.0");
        return parent;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] generatePackData() {
        if (this.packData != null) {
            return this.packData;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                String manifestJson = GSON.toJson((Object)this.manifest);
                zos.putNextEntry(new ZipEntry("manifest.json"));
                zos.write(manifestJson.getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
                try (InputStream is = EmoteResourcePack.class.getClassLoader().getResourceAsStream("emotecraft_mod_logo.png");){
                    zos.putNextEntry(new ZipEntry("pack_icon.png"));
                    zos.write(Objects.requireNonNull(is).readAllBytes());
                    zos.closeEntry();
                }
                catch (Throwable th) {
                    CommonData.LOGGER.warn("Failed to put icon!", th);
                }
                String animationJson = this.generateAnimation().toString();
                zos.putNextEntry(new ZipEntry("animations/player.animation.json"));
                zos.write(animationJson.getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
                zos.finish();
                this.packData = baos.toByteArray();
                byArray = this.packData;
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate resource pack", e);
        }
    }

    private JsonArray generateBone(boolean rotate, int x, int y, int z, float defaultValue, EnumMap<Axis, Integer> axisMap) {
        axisMap.put(Axis.X, x);
        axisMap.put(Axis.Y, y);
        axisMap.put(Axis.Z, z);
        JsonArray axis = new JsonArray();
        axis.add(this.molangScript.replace("{LERP_VALUE}", rotate ? "0" : "1").replace("{BONE_ID_RAW}", String.valueOf(x)).replace("{BONE_ID}", String.valueOf(x).replace("-", "_")).replace("{DEFAULT_VALUE}", String.valueOf(defaultValue)));
        axis.add(this.molangScript.replace("{LERP_VALUE}", rotate ? "0" : "1").replace("{BONE_ID_RAW}", String.valueOf(y)).replace("{BONE_ID}", String.valueOf(y).replace("-", "_")).replace("{DEFAULT_VALUE}", String.valueOf(defaultValue)));
        axis.add(this.molangScript.replace("{LERP_VALUE}", rotate ? "0" : "1").replace("{BONE_ID_RAW}", String.valueOf(z)).replace("{BONE_ID}", String.valueOf(z).replace("-", "_")).replace("{DEFAULT_VALUE}", String.valueOf(defaultValue)));
        return axis;
    }

    public byte @NonNull [] sha256() {
        if (this.sha256 != null) {
            return this.sha256;
        }
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256").digest(this.generatePackData());
            return this.sha256;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not calculate pack hash", e);
        }
    }

    public long size() {
        return this.generatePackData().length;
    }

    public @NonNull SeekableByteChannel serialize() {
        return new SeekableInMemoryByteChannel(this.generatePackData());
    }

    protected @NonNull ResourcePack create() {
        return new GeyserResourcePack((PackCodec)this, this.manifest, "");
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ResourcePack.Builder createBuilder() {
        throw new UnsupportedOperationException();
    }

    @Subscribe(postOrder=PostOrder.LAST)
    public void onDefineEntityProperties(GeyserDefineEntityPropertiesEvent event) {
        int reserved = 32;
        CommonData.LOGGER.info("{} properties will be reserved by emotecraft! Please ignore the warnings below...", (Object)reserved);
        StringBuilder molangScript = new StringBuilder("variable.bone_{BONE_ID} = variable.bone_{BONE_ID} ?? {DEFAULT_VALUE};");
        molangScript.append("variable.bone_{BONE_ID}_target = variable.bone_{BONE_ID}_target ?? {DEFAULT_VALUE};");
        this.registeredProperties.clear();
        for (int i = 0; i < reserved; ++i) {
            Identifier identifier = Identifier.of((String)"emotecraft", (String)String.format("property_%s", i));
            this.registeredProperties.add(event.registerIntegerProperty(PLAYER_IDENTIFIER, identifier, -1000000, 999949));
            String prop = "variable." + identifier.path();
            molangScript.append(prop).append(" = q.property('").append(identifier).append("');");
            molangScript.append("variable._raw = ").append(prop).append(" + 1000000;");
            molangScript.append("variable._id = math.floor(variable._raw / ").append(10050).append(") - 99;");
            molangScript.append("variable._val = (math.mod(variable._raw, ").append(10050).append(") - ").append(5025).append(") / ").append(10).append(";");
            molangScript.append("variable.bone_{BONE_ID}_target = (variable._id == {BONE_ID_RAW}) ? ").append("variable._val : variable.bone_{BONE_ID}_target;");
        }
        molangScript.append("variable.bone_{BONE_ID} = ({LERP_VALUE} == 1) ? (");
        molangScript.append("(math.abs(variable.bone_{BONE_ID} - variable.bone_{BONE_ID}_target) < 0.001) ? variable.bone_{BONE_ID}_target : math.lerp(variable.bone_{BONE_ID}, variable.bone_{BONE_ID}_target, 0.2)");
        molangScript.append(") : variable.bone_{BONE_ID}_target;");
        molangScript.append("return variable.bone_{BONE_ID};");
        CommonData.LOGGER.debug("Registered {} properties!", (Object)this.registeredProperties.size());
        this.molangScript = molangScript.toString();
    }

    public Set<GeyserIntEntityProperty> getRegisteredProperties() {
        return Collections.unmodifiableSet(this.registeredProperties);
    }

    public Map<Axis, Integer> getAxisIds(String part, TransformType type) {
        return Collections.unmodifiableMap((Map)this.identifiers.get(part).get(type));
    }

    @Subscribe
    public void onDefineResourcePacks(GeyserDefineResourcePacksEvent event) {
        event.register(this.create(), new ResourcePackOption[0]);
    }
}

