/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.animator.geometry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.zigythebird.playeranimcore.PlayerAnimLib;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import io.github.kosmx.emotes.common.CommonData;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Set;
import org.geysermc.geyser.api.skin.SkinGeometry;
import org.geysermc.geyser.skin.SkinManager;
import org.redlance.dima_dencep.mods.emotecraft.geyser.fuckery.ReflectHacks;

public class BendingGeometry {
    private static final VarHandle SKIN_MANAGER_GEOMETRY = ReflectHacks.uncheck(() -> ReflectHacks.TRUSTED_LOOKUP.findStaticVarHandle(SkinManager.class, "GEOMETRY", String.class));
    public static final Set<String> BENDABLE_BONES = Set.of("right_arm", "left_arm", "body", "right_leg", "left_leg");
    public static final String BEND_SUFFIX = "_bend";

    public static SkinGeometry addBoneBends(SkinGeometry geometry) {
        JsonObject geometryObj = (JsonObject)PlayerAnimLib.GSON.fromJson(geometry.geometryData().isBlank() ? SKIN_MANAGER_GEOMETRY.get() : geometry.geometryData(), JsonObject.class);
        for (JsonElement element : geometryObj.getAsJsonArray("minecraft:geometry")) {
            BendingGeometry.addBoneBends(element.getAsJsonObject());
        }
        return new SkinGeometry(geometry.geometryName(), PlayerAnimLib.GSON.toJson((JsonElement)geometryObj));
    }

    private static void addBoneBends(JsonObject geometry) {
        String identifier = geometry.getAsJsonObject("description").get("identifier").getAsString();
        CommonData.LOGGER.debug("Patching '{}' for bends...", (Object)identifier);
        JsonArray bones = geometry.getAsJsonArray("bones");
        for (JsonElement element : new ArrayList(bones.asList())) {
            String boneName;
            JsonObject boneObj = element.getAsJsonObject();
            if (!boneObj.has("cubes") || !BENDABLE_BONES.contains(boneName = UniversalAnimLoader.getCorrectPlayerBoneName((String)boneObj.get("name").getAsString()))) continue;
            BendingGeometry.addBoneBendsToBone(bones, boneObj);
        }
        geometry.add("bones", (JsonElement)bones);
    }

    private static void addBoneBendsToBone(JsonArray bones, JsonObject bone) {
        int boneSize = bone.getAsJsonArray("cubes").get(0).getAsJsonObject().getAsJsonArray("size").get(1).getAsInt();
        JsonObject secondBone = BendingGeometry.makeCubeBendable(bone, true);
        String name = bone.get("name").getAsString();
        for (JsonElement element : new ArrayList(bones.asList())) {
            JsonObject firstCube;
            JsonObject boneObj = element.getAsJsonObject();
            if (!boneObj.has("parent") || !name.equals(boneObj.get("parent").getAsString())) continue;
            JsonObject jsonObject = firstCube = boneObj.has("cubes") ? boneObj.getAsJsonArray("cubes").get(0).getAsJsonObject() : new JsonObject();
            if (firstCube.has("inflate") && boneSize == firstCube.getAsJsonArray("size").get(1).getAsInt()) {
                CommonData.LOGGER.debug("Second layer detected! {}", (Object)boneObj);
                JsonObject secondBoneSecondLayer = BendingGeometry.makeCubeBendable(boneObj, false);
                boneObj.add("parent", bone.get("name"));
                secondBoneSecondLayer.add("parent", secondBone.get("name"));
                bones.add((JsonElement)secondBoneSecondLayer);
                continue;
            }
            boneObj.add("parent", secondBone.get("name"));
        }
        bones.add((JsonElement)secondBone);
    }

    private static JsonObject makeCubeBendable(JsonObject bone, boolean drawCrossSection) {
        JsonObject face;
        String[] sides;
        JsonObject bendableCube = bone.getAsJsonArray("cubes").get(0).getAsJsonObject();
        if (bendableCube.get("uv").isJsonArray()) {
            bendableCube.add("uv", (JsonElement)BendingGeometry.expandCubeUV(bendableCube));
        }
        JsonArray size = bendableCube.getAsJsonArray("size");
        size.set(1, (JsonElement)new JsonPrimitive((Number)Float.valueOf(size.get(1).getAsFloat() / 2.0f)));
        JsonObject secondBendableCube = bendableCube.deepCopy();
        float secondBendableCubeSizeY = secondBendableCube.getAsJsonArray("size").get(1).getAsFloat();
        JsonObject uv = secondBendableCube.getAsJsonObject("uv");
        for (String side : sides = new String[]{"north", "south", "east", "west"}) {
            face = uv.getAsJsonObject(side);
            JsonArray uvCoords = face.getAsJsonArray("uv");
            uvCoords.set(1, (JsonElement)new JsonPrimitive((Number)Float.valueOf(uvCoords.get(1).getAsFloat() + secondBendableCubeSizeY)));
            JsonArray uvSize = face.getAsJsonArray("uv_size");
            uvSize.set(1, (JsonElement)new JsonPrimitive((Number)Float.valueOf(secondBendableCubeSizeY)));
        }
        if (!drawCrossSection) {
            uv.remove("up");
        }
        uv = bendableCube.getAsJsonObject("uv");
        for (String side : sides = new String[]{"north", "south", "east", "west"}) {
            face = uv.getAsJsonObject(side);
            JsonArray uvSize = face.getAsJsonArray("uv_size");
            uvSize.set(1, (JsonElement)new JsonPrimitive((Number)Float.valueOf(secondBendableCubeSizeY)));
        }
        if (drawCrossSection) {
            uv.add("down", (JsonElement)uv.getAsJsonObject("up").deepCopy());
        } else {
            uv.remove("down");
        }
        JsonArray secondCubes = new JsonArray();
        secondCubes.add((JsonElement)secondBendableCube);
        float sizeY = bendableCube.getAsJsonArray("size").get(1).getAsFloat();
        JsonArray origin = bendableCube.getAsJsonArray("origin");
        origin.set(1, (JsonElement)new JsonPrimitive((Number)Float.valueOf(origin.get(1).getAsFloat() + sizeY)));
        JsonObject secondBone = new JsonObject();
        secondBone.add("parent", bone.get("name"));
        secondBone.addProperty("name", UniversalAnimLoader.restorePlayerBoneName((String)(bone.get("name").getAsString() + BEND_SUFFIX)));
        secondBone.add("cubes", (JsonElement)secondCubes);
        JsonArray pivot = new JsonArray();
        pivot.add(bone.get("pivot").getAsJsonArray().get(0));
        pivot.add((Number)Float.valueOf(bone.get("pivot").getAsJsonArray().get(1).getAsFloat() - secondBendableCubeSizeY));
        pivot.add(bone.get("pivot").getAsJsonArray().get(2));
        secondBone.add("pivot", (JsonElement)pivot);
        return secondBone;
    }

    public static JsonObject expandCubeUV(JsonObject cube) {
        JsonArray uvArray = cube.getAsJsonArray("uv");
        float u = uvArray.get(0).getAsFloat();
        float v = uvArray.get(1).getAsFloat();
        JsonArray sizeArray = cube.getAsJsonArray("size");
        float w = sizeArray.get(0).getAsFloat();
        float h = sizeArray.get(1).getAsFloat();
        float d = sizeArray.get(2).getAsFloat();
        JsonObject root = new JsonObject();
        root.add("east", (JsonElement)BendingGeometry.createFace(u, v + d, d, h));
        root.add("north", (JsonElement)BendingGeometry.createFace(u + d, v + d, w, h));
        root.add("west", (JsonElement)BendingGeometry.createFace(u + d + w, v + d, d, h));
        root.add("south", (JsonElement)BendingGeometry.createFace(u + d + w + d, v + d, w, h));
        root.add("up", (JsonElement)BendingGeometry.createFace(u + d, v, w, d));
        root.add("down", (JsonElement)BendingGeometry.createFace(u + d + w, v, w, d));
        return root;
    }

    private static JsonObject createFace(float u, float v, float w, float h) {
        JsonObject face = new JsonObject();
        JsonArray uv = new JsonArray();
        uv.add((Number)Float.valueOf(u));
        uv.add((Number)Float.valueOf(v));
        face.add("uv", (JsonElement)uv);
        JsonArray size = new JsonArray();
        size.add((Number)Float.valueOf(w));
        size.add((Number)Float.valueOf(h));
        face.add("uv_size", (JsonElement)size);
        return face;
    }
}

