/*
 * Decompiled with CFR 0.152.
 */
package org.redlance.dima_dencep.mods.emotecraft.geyser.animator;

import com.google.common.collect.Sets;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.HumanoidAnimationController;
import com.zigythebird.playeranimcore.bones.PlayerAnimBone;
import com.zigythebird.playeranimcore.enums.Axis;
import com.zigythebird.playeranimcore.enums.PlayState;
import com.zigythebird.playeranimcore.enums.TransformType;
import com.zigythebird.playeranimcore.molang.MolangLoader;
import com.zigythebird.playeranimcore.util.MatrixUtil;
import io.github.kosmx.emotes.common.CommonData;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.geysermc.geyser.api.entity.property.GeyserEntityProperty;
import org.geysermc.geyser.api.entity.property.type.GeyserIntEntityProperty;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.properties.GeyserEntityPropertyManager;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.redlance.dima_dencep.mods.emotecraft.geyser.EmotecraftExt;
import org.redlance.dima_dencep.mods.emotecraft.geyser.animator.PackedProperty;
import org.redlance.dima_dencep.mods.emotecraft.geyser.animator.geometry.BendingGeometry;
import org.redlance.dima_dencep.mods.emotecraft.geyser.animator.geometry.GeometryChanger;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.BedrockPacketsUtils;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.GeyserEntityUtils;
import org.redlance.dima_dencep.mods.emotecraft.geyser.utils.resourcepack.EmoteResourcePack;

public class GeyserAnimationController
extends HumanoidAnimationController {
    private final Set<Identifier> lastUsedProperties = new HashSet<Identifier>(1);
    protected final Set<AvatarEntity> listeners = Sets.newConcurrentHashSet();
    private final Set<String> dirtyBones = new HashSet<String>();
    protected final UUID avatarId;

    protected GeyserAnimationController(UUID avatarId) {
        super((controller, state, animationSetter) -> PlayState.STOP, MolangLoader::createNewEngine);
        this.avatarId = avatarId;
    }

    protected void setupNewAnimation() {
        super.setupNewAnimation();
        for (AvatarEntity avatar : this.listeners) {
            this.subscribe(avatar);
        }
        this.dirtyBones.clear();
    }

    public void subscribe(AvatarEntity avatarEntity) {
        if (this.listeners.add(avatarEntity)) {
            GeometryChanger.changeGeometryToBending(avatarEntity).join();
            try {
                Thread.sleep(Duration.ofMillis(10L));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        BedrockPacketsUtils.sendInstantAnimation(EmoteResourcePack.ANIMATION_NAME, avatarEntity);
        for (String partKey : this.dirtyBones) {
            this.updateBone(avatarEntity.getPropertyManager(), partKey, new PlayerAnimBone(partKey));
        }
    }

    protected void handleFrameInternal() {
        try {
            AnimationData data = new AnimationData(0.0f, 1.0f, false);
            this.tick(data);
            if (!this.isActive()) {
                return;
            }
            this.setupAnim(data);
            for (String partKey : this.activeBones.keySet()) {
                if (!this.bones.containsKey(partKey)) {
                    CommonData.LOGGER.debug("Unsupported bone: {}!", (Object)partKey);
                    continue;
                }
                PlayerAnimBone bone = this.get3DTransform(new PlayerAnimBone(partKey));
                for (AvatarEntity avatarEntity : this.listeners) {
                    if (GeyserEntityUtils.unsubscribedFromEntity(avatarEntity)) {
                        this.unsubscribe(avatarEntity);
                        continue;
                    }
                    GeyserEntityPropertyManager propertyManager = avatarEntity.getPropertyManager();
                    if (propertyManager == null) continue;
                    this.updateBone(propertyManager, partKey, bone);
                }
            }
            this.flushPropertiesImmediately();
            if (this.dirtyBones.isEmpty()) {
                this.dirtyBones.addAll(this.activeBones.keySet());
            }
        }
        catch (Throwable th) {
            CommonData.LOGGER.warn("Failed to animate {}!", (Object)this.avatarId, (Object)th);
        }
    }

    protected boolean handleFrame() {
        this.handleFrameInternal();
        this.listeners.removeIf(GeyserEntityUtils::unsubscribedFromEntity);
        return this.listeners.isEmpty();
    }

    public PlayerAnimBone get3DTransform(@NonNull PlayerAnimBone bone) {
        String boneName = (bone = super.get3DTransform(bone)).getName();
        if ("left_arm".equals(boneName) || "right_arm".equals(boneName) || "head".equals(boneName)) {
            PlayerAnimBone torsoBone = this.get3DTransform(new PlayerAnimBone("torso"));
            torsoBone.mulPos(-1.0f);
            torsoBone.mulRot(-1.0f);
            torsoBone.setScaleX(1.0f / bone.getScaleX());
            torsoBone.setScaleY(1.0f / bone.getScaleY());
            torsoBone.setScaleZ(1.0f / bone.getScaleZ());
            MatrixUtil.applyParentsToChild((PlayerAnimBone)bone, Collections.singleton(torsoBone), arg_0 -> ((GeyserAnimationController)this).getBonePosition(arg_0));
        } else if ("left_leg".equals(boneName) || "right_leg".equals(boneName)) {
            PlayerAnimBone body = this.get3DTransform(new PlayerAnimBone("body"));
            MatrixUtil.applyParentsToChild((PlayerAnimBone)bone, Collections.singleton(body), arg_0 -> ((GeyserAnimationController)this).getBonePosition(arg_0));
        } else if ("cape".equals(boneName)) {
            bone.rotX *= -1.0f;
        }
        return bone;
    }

    protected void updateBone(GeyserEntityPropertyManager propertyManager, String partKey, PlayerAnimBone bone) {
        if (!this.bones.containsKey(partKey)) {
            return;
        }
        this.updateAxis(propertyManager, partKey, TransformType.POSITION, bone.getPosX(), bone.getPosY(), bone.getPosZ());
        this.updateAxis(propertyManager, partKey, TransformType.ROTATION, (float)Math.toDegrees(bone.getRotX()), (float)Math.toDegrees(bone.getRotY()), (float)Math.toDegrees(bone.getRotZ()));
        this.updateAxis(propertyManager, partKey, TransformType.SCALE, bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        if (BendingGeometry.BENDABLE_BONES.contains(partKey)) {
            this.updateBend(propertyManager, partKey + "_bend", bone.bend);
        }
    }

    protected void updateAxis(GeyserEntityPropertyManager propertyManager, String partKey, TransformType type, float x, float y, float z) {
        Map<Axis, Integer> ids = EmotecraftExt.getInstance().getResourcePack().getAxisIds(partKey, type);
        GeyserAnimationController.updateProperty(propertyManager, this.getAvailableProperty(), PackedProperty.pack(ids.get(Axis.X), x));
        GeyserAnimationController.updateProperty(propertyManager, this.getAvailableProperty(), PackedProperty.pack(ids.get(Axis.Y), y));
        GeyserAnimationController.updateProperty(propertyManager, this.getAvailableProperty(), PackedProperty.pack(ids.get(Axis.Z), z));
    }

    protected void updateBend(GeyserEntityPropertyManager propertyManager, String partKey, float bend) {
        EmoteResourcePack resourcePack = EmotecraftExt.getInstance().getResourcePack();
        GeyserAnimationController.updateProperty(propertyManager, this.getAvailableProperty(), PackedProperty.pack(resourcePack.getAxisIds(partKey, TransformType.ROTATION).get(Axis.X), (float)Math.toDegrees(bend)));
        float radius = 2.0f;
        float angle = Math.abs(bend);
        GeyserAnimationController.updateProperty(propertyManager, this.getAvailableProperty(), PackedProperty.pack(resourcePack.getAxisIds(partKey, TransformType.POSITION).get(Axis.Y), (float)((double)radius * (1.0 - Math.cos(angle)))));
        GeyserAnimationController.updateProperty(propertyManager, this.getAvailableProperty(), PackedProperty.pack(resourcePack.getAxisIds(partKey, TransformType.POSITION).get(Axis.Z), (float)(-((double)radius * Math.sin(angle)))));
    }

    private GeyserIntEntityProperty getAvailableProperty() {
        for (GeyserIntEntityProperty property : EmotecraftExt.getInstance().getResourcePack().getRegisteredProperties()) {
            if (this.lastUsedProperties.contains(property.identifier())) continue;
            this.lastUsedProperties.add(property.identifier());
            return property;
        }
        this.flushPropertiesImmediately();
        return this.getAvailableProperty();
    }

    public static <T> void updateProperty(GeyserEntityPropertyManager propertyManager, @NonNull GeyserEntityProperty<T> property, @Nullable T value) {
        Objects.requireNonNull(property, "property must not be null!");
        if (!(property instanceof PropertyType)) {
            throw new IllegalArgumentException("Invalid property implementation! Got: " + property.getClass().getSimpleName());
        }
        PropertyType propertyType = (PropertyType)property;
        propertyType.apply(propertyManager, value);
    }

    private void flushPropertiesImmediately() {
        for (AvatarEntity avatarEntity : this.listeners) {
            GeyserEntityPropertyManager propertyManager = avatarEntity.getPropertyManager();
            if (propertyManager == null || !propertyManager.hasProperties()) continue;
            SetEntityDataPacket packet = new SetEntityDataPacket();
            packet.setRuntimeEntityId(avatarEntity.getGeyserId());
            propertyManager.applyFloatProperties(packet.getProperties().getFloatProperties());
            propertyManager.applyIntProperties(packet.getProperties().getIntProperties());
            avatarEntity.getSession().sendUpstreamPacketImmediately((BedrockPacket)packet);
        }
        try {
            Thread.sleep(Duration.ofMillis(10L));
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return;
        }
        this.lastUsedProperties.clear();
    }

    public void process(AnimationData state) {
        super.process(state);
        if (!this.animationState.isActive()) {
            this.internalStop();
        }
    }

    public void stop() {
        super.stop();
        this.internalStop();
    }

    protected void internalStop() {
        for (AvatarEntity avatarEntity : this.listeners) {
            BedrockPacketsUtils.sendBobAnimation(avatarEntity);
        }
    }

    public void unsubscribe(AvatarEntity avatarEntity) {
        if (this.listeners.remove(avatarEntity)) {
            BedrockPacketsUtils.sendBobAnimation(avatarEntity);
        }
    }

    public static Collection<String> getRegisteredBones() {
        GeyserAnimationController controller = new GeyserAnimationController(UUID.randomUUID());
        HashSet bones = new HashSet(controller.bones.keySet());
        for (String bendable : BendingGeometry.BENDABLE_BONES) {
            bones.add(bendable + "_bend");
        }
        return Collections.unmodifiableCollection(bones);
    }
}

